/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class Decimal {
    public static final int PACKED_DECIMAL = 48;
    private static MessageUtil msgutil = SqlException.getMessageUtil();
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};

    private Decimal() {
    }

    private static final int packedNybblesToInt(byte[] buffer, int offset, int startNybble, int numberOfNybbles) {
        int value = 0;
        int i = startNybble / 2;
        if (startNybble % 2 != 0) {
            value += buffer[offset + i] & 0xF;
            ++i;
        }
        int endNybble = startNybble + numberOfNybbles - 1;
        while (i < (endNybble + 1) / 2) {
            value = value * 10 + ((buffer[offset + i] & 0xF0) >>> 4);
            value = value * 10 + (buffer[offset + i] & 0xF);
            ++i;
        }
        if (endNybble % 2 == 0) {
            value = value * 10 + ((buffer[offset + i] & 0xF0) >>> 4);
        }
        return value;
    }

    private static final long packedNybblesToLong(byte[] buffer, int offset, int startNybble, int numberOfNybbles) {
        long value = 0L;
        int i = startNybble / 2;
        if (startNybble % 2 != 0) {
            value += (long)(buffer[offset + i] & 0xF);
            ++i;
        }
        int endNybble = startNybble + numberOfNybbles - 1;
        while (i < (endNybble + 1) / 2) {
            value = value * 10L + (long)((buffer[offset + i] & 0xF0) >>> 4);
            value = value * 10L + (long)(buffer[offset + i] & 0xF);
            ++i;
        }
        if (endNybble % 2 == 0) {
            value = value * 10L + (long)((buffer[offset + i] & 0xF0) >>> 4);
        }
        return value;
    }

    private static final int[] computeMagnitude(int[] input) {
        int length = input.length;
        int[] mag = new int[length];
        mag[length - 1] = input[length - 1];
        for (int i = 0; i < length - 1; ++i) {
            int carry = 0;
            int j = tenRadixMagnitude[i].length - 1;
            int k = length - 1;
            while (j >= 0) {
                long product = ((long)input[length - 2 - i] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i][j] & 0xFFFFFFFFL) + ((long)mag[k] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
                carry = (int)(product >>> 32);
                mag[k] = (int)(product & 0xFFFFFFFFL);
                --j;
                --k;
            }
            mag[k] = carry;
        }
        return mag;
    }

    public static final BigDecimal getBigDecimal(byte[] buffer, int offset, int precision, int scale) throws UnsupportedEncodingException {
        int length = precision / 2 + 1;
        int signum = (buffer[offset + length - 1] & 0xF) == 13 ? -1 : 1;
        if (precision <= 9) {
            int value = Decimal.packedNybblesToInt(buffer, offset, 0, length * 2 - 1);
            byte[] magnitude = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        if (precision <= 18) {
            long value = Decimal.packedNybblesToLong(buffer, offset, 0, length * 2 - 1);
            byte[] magnitude = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        if (precision <= 27) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int me = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 10) * 2 + 1);
            int[] value = Decimal.computeMagnitude(new int[]{hi, me, lo});
            byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1], (byte)(value[2] >>> 24), (byte)(value[2] >>> 16), (byte)(value[2] >>> 8), (byte)value[2]};
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        if (precision <= 31) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int meLo = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int meHi = Decimal.packedNybblesToInt(buffer, offset, (length - 14) * 2, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 14) * 2);
            int[] value = Decimal.computeMagnitude(new int[]{hi, meHi, meLo, lo});
            byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1], (byte)(value[2] >>> 24), (byte)(value[2] >>> 16), (byte)(value[2] >>> 8), (byte)value[2], (byte)(value[3] >>> 24), (byte)(value[3] >>> 16), (byte)(value[3] >>> 8), (byte)value[3]};
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2"));
    }

    public static final double getDouble(byte[] buffer, int offset, int precision, int scale) throws UnsupportedEncodingException {
        int length = precision / 2 + 1;
        int signum = (buffer[offset + length - 1] & 0xF) == 13 ? -1 : 1;
        if (precision <= 9) {
            int value = Decimal.packedNybblesToInt(buffer, offset, 0, length * 2 - 1);
            return (double)(signum * value) / Math.pow(10.0, scale);
        }
        if (precision <= 18) {
            long value = Decimal.packedNybblesToLong(buffer, offset, 0, length * 2 - 1);
            return (double)((long)signum * value) / Math.pow(10.0, scale);
        }
        if (precision <= 27) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int me = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 10) * 2 + 1);
            return (double)signum * ((double)lo / Math.pow(10.0, scale) + (double)me * Math.pow(10.0, 9 - scale) + (double)hi * Math.pow(10.0, 18 - scale));
        }
        if (precision <= 31) {
            int lo = Decimal.packedNybblesToInt(buffer, offset, (length - 5) * 2, 9);
            int meLo = Decimal.packedNybblesToInt(buffer, offset, (length - 10) * 2 + 1, 9);
            int meHi = Decimal.packedNybblesToInt(buffer, offset, (length - 14) * 2, 9);
            int hi = Decimal.packedNybblesToInt(buffer, offset, 0, (length - 14) * 2);
            return (double)signum * ((double)lo / Math.pow(10.0, scale) + (double)meLo * Math.pow(10.0, 9 - scale) + (double)meHi * Math.pow(10.0, 18 - scale) + (double)hi * Math.pow(10.0, 27 - scale));
        }
        throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2"));
    }

    public static final long getLong(byte[] buffer, int offset, int precision, int scale) throws UnsupportedEncodingException {
        if (precision > 31) {
            throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2"));
        }
        int length = precision / 2 + 1;
        int signum = (buffer[offset + length - 1] & 0xF) == 13 ? -1 : 1;
        int leftOfDecimalPoint = length * 2 - 1 - scale;
        long integer = 0L;
        if (leftOfDecimalPoint > 0) {
            int i;
            for (i = 0; i < leftOfDecimalPoint / 2; ++i) {
                integer = integer * 10L + (long)(signum * ((buffer[offset + i] & 0xF0) >>> 4));
                integer = integer * 10L + (long)(signum * (buffer[offset + i] & 0xF));
            }
            if (leftOfDecimalPoint % 2 == 1) {
                integer = integer * 10L + (long)(signum * ((buffer[offset + i] & 0xF0) >>> 4));
            }
        }
        return integer;
    }

    public static final int bigDecimalToPackedDecimalBytes(byte[] buffer, int offset, BigDecimal b, int declaredPrecision, int declaredScale) throws SqlException {
        int bigIndex;
        int declaredWholeIntegerLength;
        if (declaredPrecision > 31) {
            throw new SqlException(null, new ClientMessageId("22003.S.2"));
        }
        String unscaledStr = b.unscaledValue().abs().toString();
        int bigPrecision = unscaledStr.length();
        if (bigPrecision > 31) {
            throw new SqlException(null, new ClientMessageId("22003"), (Object)"packed decimal", new SqlCode(-405));
        }
        int bigScale = b.scale();
        int bigWholeIntegerLength = bigPrecision - bigScale;
        if (bigWholeIntegerLength > 0 && !unscaledStr.equals("0") && bigWholeIntegerLength > (declaredWholeIntegerLength = declaredPrecision - declaredScale)) {
            throw new SqlException(null, new ClientMessageId("22003.S.3"), (Object)b.toString(), (Object)"packed decimal", new SqlCode(-413));
        }
        int zeroBase = 48;
        int packedIndex = declaredPrecision - 1;
        if (bigScale >= declaredScale) {
            bigIndex = bigPrecision - 1 - (bigScale - declaredScale);
            buffer[offset + (packedIndex + 1) / 2] = bigIndex < 0 ? (byte)(b.signum() >= 0 ? 12 : 13) : (byte)((unscaledStr.charAt(bigIndex) - zeroBase << 4) + (b.signum() >= 0 ? 12 : 13));
            packedIndex -= 2;
            bigIndex -= 2;
        } else {
            bigIndex = declaredScale - bigScale - 1;
            buffer[offset + (packedIndex + 1) / 2] = (byte)(b.signum() >= 0 ? 12 : 13);
            packedIndex -= 2;
            bigIndex -= 2;
            while (bigIndex >= 0) {
                buffer[offset + (packedIndex + 1) / 2] = 0;
                packedIndex -= 2;
                bigIndex -= 2;
            }
            if (bigIndex == -1) {
                buffer[offset + (packedIndex + 1) / 2] = (byte)(unscaledStr.charAt(bigPrecision - 1) - zeroBase << 4);
                packedIndex -= 2;
                bigIndex = bigPrecision - 3;
            } else {
                bigIndex = bigPrecision - 2;
            }
        }
        while (bigIndex >= 0) {
            buffer[offset + (packedIndex + 1) / 2] = (byte)((unscaledStr.charAt(bigIndex) - zeroBase << 4) + (unscaledStr.charAt(bigIndex + 1) - zeroBase));
            packedIndex -= 2;
            bigIndex -= 2;
        }
        if (bigIndex == -1) {
            buffer[offset + (packedIndex + 1) / 2] = (byte)(unscaledStr.charAt(0) - zeroBase);
            packedIndex -= 2;
        }
        while (packedIndex >= -1) {
            buffer[offset + (packedIndex + 1) / 2] = 0;
            packedIndex -= 2;
        }
        return declaredPrecision / 2 + 1;
    }
}

