/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class EncryptionManager {
    transient Agent agent_;
    private static final byte[] modulusBytes__ = new byte[]{-58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    private static final BigInteger modulus__ = new BigInteger(1, modulusBytes__);
    private static final byte[] baseBytes__ = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    private static final BigInteger base__ = new BigInteger(1, baseBytes__);
    private static final int exponential_length__ = 255;
    private DHParameterSpec paramSpec_;
    private KeyPairGenerator keyPairGenerator_;
    private KeyPair keyPair_;
    private KeyAgreement keyAgreement_;
    private byte[] token_;
    private byte[] secKey_;
    private SecretKeyFactory secretKeyFactory_ = null;
    private String providerName;
    private Provider provider;
    private MessageDigest messageDigest = null;
    private SecureRandom secureRandom = null;
    private static final int SECMEC_USRSSBPWD_SEED_LEN = 8;
    private static final byte[] SECMEC_USRSSBPWD_PWDSEQS = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
    private static final String SHA_1_PRNG_ALGORITHM = "SHA1PRNG";
    public static final String SHA_1_DIGEST_ALGORITHM = "SHA-1";
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public EncryptionManager(Agent agent) throws SqlException {
        this.agent_ = agent;
        try {
            Provider[] list = Security.getProviders("KeyAgreement.DH");
            if (list == null) {
                throw new NoSuchProviderException();
            }
            this.provider = list[0];
            this.providerName = this.provider.getName();
            this.paramSpec_ = new DHParameterSpec(modulus__, base__, 255);
            this.keyPairGenerator_ = KeyPairGenerator.getInstance("DH", this.providerName);
            this.keyPairGenerator_.initialize(this.paramSpec_);
            this.keyPair_ = this.keyPairGenerator_.generateKeyPair();
            this.keyAgreement_ = KeyAgreement.getInstance("DH", this.providerName);
            this.keyAgreement_.init(this.keyPair_.getPrivate());
        }
        catch (GeneralSecurityException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), e);
        }
    }

    public EncryptionManager(Agent agent, String algorithm) throws SqlException {
        this.agent_ = agent;
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
            this.secureRandom = SecureRandom.getInstance(SHA_1_PRNG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), nsae);
        }
    }

    public byte[] obtainPublicKey() {
        BigInteger aPub = ((DHPublicKey)this.keyPair_.getPublic()).getY();
        byte[] aPubKey = aPub.toByteArray();
        if (aPubKey.length == 33 && aPubKey[0] == 0) {
            byte[] newKey = new byte[32];
            for (int i = 0; i < newKey.length; ++i) {
                newKey[i] = aPubKey[i + 1];
            }
            return newKey;
        }
        if (aPubKey.length < 32) {
            int i;
            byte[] newKey = new byte[32];
            for (i = 0; i < 32 - aPubKey.length; ++i) {
                newKey[i] = 0;
            }
            for (int j = i; j < newKey.length; ++j) {
                newKey[j] = aPubKey[j - i];
            }
            return newKey;
        }
        return aPubKey;
    }

    private byte[] calculateEncryptionToken(int securityMechanism, byte[] initVector) {
        byte[] token;
        block7: {
            block6: {
                token = new byte[8];
                if (securityMechanism != 7) break block6;
                if (initVector.length < 8) {
                    int i;
                    for (i = 0; i < initVector.length; ++i) {
                        token[i] = initVector[i];
                    }
                    for (i = initVector.length; i < 8; ++i) {
                        token[i] = 0;
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        token[i] = initVector[i];
                    }
                }
                break block7;
            }
            if (securityMechanism != 9) break block7;
            for (int i = 0; i < 8; ++i) {
                token[i] = initVector[i + 12];
            }
        }
        return token;
    }

    private void keyParityCheck(byte[] key) throws SqlException {
        if (key.length != 8) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ105.S"), (Object)new Integer(8), new Integer(key.length));
        }
        for (int i = 0; i < 8; ++i) {
            byte temp = key[i];
            int changeParity = 1;
            for (int j = 0; j < 8; ++j) {
                if (temp < 0) {
                    changeParity = 1 - changeParity;
                }
                temp = (byte)(temp << 1);
            }
            if (changeParity != true) continue;
            if ((key[i] & 1) != 0) {
                int n = i;
                key[n] = (byte)(key[n] & 0xFE);
                continue;
            }
            int n = i;
            key[n] = (byte)(key[n] | 1);
        }
    }

    private byte[] generatePrivateKey(byte[] targetPublicKey) throws SqlException {
        try {
            int i;
            int i2;
            KeyFactory keyFac = KeyFactory.getInstance("DH", this.provider);
            BigInteger publicKey = new BigInteger(1, targetPublicKey);
            DHPublicKeySpec dhKeySpec = new DHPublicKeySpec(publicKey, modulus__, base__);
            PublicKey pubKey = keyFac.generatePublic(dhKeySpec);
            this.keyAgreement_.doPhase(pubKey, true);
            byte[] sharedSecret = this.keyAgreement_.generateSecret();
            byte[] newKey = new byte[32];
            if (sharedSecret.length == 33 && sharedSecret[0] == 0) {
                for (i2 = 0; i2 < newKey.length; ++i2) {
                    newKey[i2] = sharedSecret[i2 + 1];
                }
            }
            if (sharedSecret.length < 32) {
                for (i2 = 0; i2 < 32 - sharedSecret.length; ++i2) {
                    newKey[i2] = 0;
                }
                for (int j = i2; j < sharedSecret.length; ++j) {
                    newKey[j] = sharedSecret[j - i2];
                }
            }
            byte[] key = new byte[8];
            if (sharedSecret.length == 32) {
                for (i = 0; i < 8; ++i) {
                    key[i] = sharedSecret[i + 12];
                }
            } else if (sharedSecret.length == 33 || sharedSecret.length < 32) {
                for (i = 0; i < 8; ++i) {
                    key[i] = newKey[i + 12];
                }
            } else {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ104.S"), new Integer(sharedSecret.length));
            }
            this.keyParityCheck(key);
            return key;
        }
        catch (GeneralSecurityException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), e);
        }
    }

    public byte[] encryptData(byte[] plainText, int securityMechanism, byte[] initVector, byte[] targetPublicKey) throws SqlException {
        byte[] cipherText = null;
        Object key = null;
        if (this.token_ == null) {
            this.token_ = this.calculateEncryptionToken(securityMechanism, initVector);
        }
        try {
            KeySpec desKey;
            if (this.secKey_ == null) {
                this.secKey_ = this.generatePrivateKey(targetPublicKey);
                desKey = new SecretKeySpec(this.secKey_, "DES");
                key = desKey;
            } else {
                desKey = new DESKeySpec(this.secKey_);
                if (this.secretKeyFactory_ == null) {
                    this.secretKeyFactory_ = SecretKeyFactory.getInstance("DES", this.providerName);
                }
                key = this.secretKeyFactory_.generateSecret(desKey);
            }
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", this.providerName);
            IvParameterSpec ivParam = new IvParameterSpec(this.token_);
            cipher.init(1, (Key)key, ivParam);
            cipherText = cipher.doFinal(plainText);
        }
        catch (NoSuchPaddingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ106.S"));
        }
        catch (BadPaddingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ107.S"));
        }
        catch (IllegalBlockSizeException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ108.S"));
        }
        catch (GeneralSecurityException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), e);
        }
        return cipherText;
    }

    public byte[] decryptData(byte[] cipherText, int securityMechanism, byte[] initVector, byte[] targetPublicKey) throws SqlException {
        byte[] plainText = null;
        Object key = null;
        if (this.token_ == null) {
            this.token_ = this.calculateEncryptionToken(securityMechanism, initVector);
        }
        try {
            KeySpec desKey;
            if (this.secKey_ == null) {
                this.secKey_ = this.generatePrivateKey(targetPublicKey);
                desKey = new SecretKeySpec(this.secKey_, "DES");
                key = desKey;
            } else {
                desKey = new DESKeySpec(this.secKey_);
                if (this.secretKeyFactory_ == null) {
                    this.secretKeyFactory_ = SecretKeyFactory.getInstance("DES", this.providerName);
                }
                key = this.secretKeyFactory_.generateSecret(desKey);
            }
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", this.providerName);
            IvParameterSpec ivParam = new IvParameterSpec(this.token_);
            cipher.init(2, (Key)key, ivParam);
            plainText = cipher.doFinal(cipherText);
        }
        catch (NoSuchPaddingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ106.S"));
        }
        catch (BadPaddingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ107.S"));
        }
        catch (IllegalBlockSizeException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ108.S"));
        }
        catch (GeneralSecurityException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), e);
        }
        return plainText;
    }

    public void setInitVector(byte[] initVector) {
        this.token_ = initVector;
    }

    public void setSecKey(byte[] secKey) {
        this.secKey_ = secKey;
    }

    public void resetSecurityKeys() {
        this.token_ = null;
        this.secKey_ = null;
    }

    public byte[] generateSeed() {
        byte[] randomSeedBytes = new byte[8];
        this.secureRandom.setSeed(this.secureRandom.generateSeed(8));
        this.secureRandom.nextBytes(randomSeedBytes);
        return randomSeedBytes;
    }

    public byte[] substitutePassword(String userName, String password, byte[] sourceSeed_, byte[] targetSeed_) throws SqlException {
        String ID_PATTERN_NEW_SCHEME = "3b60";
        SanityManager.ASSERT(this.messageDigest != null && SHA_1_DIGEST_ALGORITHM.equals(this.messageDigest.getAlgorithm()));
        this.messageDigest.reset();
        this.messageDigest.update(this.toHexByte(password, 0, password.length()));
        byte[] encryptVal = this.messageDigest.digest();
        String hexString = ID_PATTERN_NEW_SCHEME + this.toHexString(encryptVal, 0, encryptVal.length);
        byte[] userBytes = this.toHexByte(userName, 0, userName.length());
        this.messageDigest.update(userBytes);
        this.messageDigest.update(this.toHexByte(hexString, 0, hexString.length()));
        byte[] passwordToken = this.messageDigest.digest();
        this.messageDigest.update(passwordToken);
        this.messageDigest.update(targetSeed_);
        this.messageDigest.update(sourceSeed_);
        this.messageDigest.update(userBytes);
        this.messageDigest.update(SECMEC_USRSSBPWD_PWDSEQS);
        byte[] passwordSubstitute = this.messageDigest.digest();
        return passwordSubstitute;
    }

    private String toHexString(byte[] data, int offset, int length) {
        StringBuffer s = new StringBuffer(length * 2);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            int high_nibble = (data[i] & 0xF0) >>> 4;
            int low_nibble = data[i] & 0xF;
            s.append(hex_table[high_nibble]);
            s.append(hex_table[low_nibble]);
        }
        return s.toString();
    }

    private byte[] toHexByte(String str, int offset, int length) {
        byte[] data = new byte[(length - offset) * 2];
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            char ch = str.charAt(i);
            int high_nibble = (ch & 0xF0) >>> 4;
            int low_nibble = ch & 0xF;
            data[i] = (byte)high_nibble;
            data[i + 1] = (byte)low_nibble;
        }
        return data;
    }
}

