/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedCallableStatement
extends EmbedPreparedStatement
implements CallableStatement {
    private boolean hasReturnOutputParameter;
    protected boolean wasNull;

    public EmbedCallableStatement(EmbedConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, sql, false, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        ParameterValueSet pvs = this.getParms();
        this.hasReturnOutputParameter = pvs.hasReturnOutputParameter();
    }

    protected void checkRequiresCallableStatement(Activation activation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.wasNull = false;
            try {
                this.getParms().validate();
            }
            catch (StandardException e) {
                throw EmbedResultSet.noStateChangeException(e);
            }
            boolean execResult = super.executeStatement(a, executeQuery, executeUpdate && !this.hasReturnOutputParameter);
            ParameterValueSet pvs = this.getParms();
            if (this.hasReturnOutputParameter) {
                SanityManager.ASSERT(this.results != null, "null results even though we are supposed to have a return parameter");
                boolean gotRow = this.results.next();
                SanityManager.ASSERT(gotRow, "the return resultSet didn't have any rows");
                try {
                    DataValueDescriptor returnValue = pvs.getReturnValueForSet();
                    returnValue.setValueFromResultSet(this.results, 1, true);
                }
                catch (StandardException e) {
                    throw EmbedResultSet.noStateChangeException(e);
                }
                finally {
                    this.results.close();
                    this.results = null;
                }
                execResult = false;
            }
            return execResult;
        }
    }

    public final void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().registerOutParameter(parameterIndex - 1, sqlType, -1);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public final void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.checkStatus();
        if (scale < 0) {
            throw this.newSQLException("XJ044.S", new Integer(scale));
        }
        try {
            this.getParms().registerOutParameter(parameterIndex - 1, sqlType, scale);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Util.notImplemented("registerOutParameter");
    }

    public boolean wasNull() throws SQLException {
        this.checkStatus();
        return this.wasNull;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            String v = this.getParms().getParameterForGet(parameterIndex - 1).getString();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            boolean v = param.getBoolean();
            this.wasNull = !v && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            byte b = param.getByte();
            this.wasNull = b == 0 && param.isNull();
            return b;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            short s = param.getShort();
            this.wasNull = s == 0 && param.isNull();
            return s;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            int v = param.getInt();
            this.wasNull = v == 0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            long v = param.getLong();
            this.wasNull = v == 0L && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            float v = param.getFloat();
            this.wasNull = (double)v == 0.0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            double v = param.getDouble();
            this.wasNull = v == 0.0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            byte[] v = this.getParms().getParameterForGet(parameterIndex - 1).getBytes();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Date v = this.getParms().getParameterForGet(parameterIndex - 1).getDate(this.getCal());
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Time v = this.getParms().getParameterForGet(parameterIndex - 1).getTime(this.getCal());
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Timestamp v = this.getParms().getParameterForGet(parameterIndex - 1).getTimestamp(this.getCal());
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getDate(parameterIndex);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTime(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(parameterIndex);
    }

    public final Object getObject(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Object v = this.getParms().getParameterForGet(parameterIndex - 1).getObject();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        throw Util.notImplemented();
    }

    public URL getURL(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    public Blob getBlob(int i) throws SQLException {
        throw Util.notImplemented();
    }

    public Clob getClob(int i) throws SQLException {
        throw Util.notImplemented();
    }

    public void addBatch() throws SQLException {
        this.checkStatus();
        ParameterValueSet pvs = this.getParms();
        int numberOfParameters = pvs.getParameterCount();
        block4: for (int j = 1; j <= numberOfParameters; ++j) {
            switch (pvs.getParameterMode(j)) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 4: {
                    throw this.newSQLException("XJ04C.S");
                }
            }
        }
        super.addBatch();
    }
}

