/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedNamespaceContext
implements NamespaceContext {
    private Map<String, List<String>> contextWithURIKey;
    private Map<String, String> contextWithPrefixKey;

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.contextWithPrefixKey == null) {
            return null;
        }
        String uri = this.contextWithPrefixKey.get(prefix);
        return uri == null ? "" : uri;
    }

    @Override
    public String getPrefix(String uri) {
        return (String)this.getPrefixGeneric(uri, true);
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        return (Iterator)this.getPrefixGeneric(uri, false);
    }

    private Object getPrefixGeneric(String uri, boolean first) {
        if (this.contextWithURIKey == null) {
            return null;
        }
        List<String> prefixes = this.contextWithURIKey.get(uri);
        if (prefixes != null && prefixes.size() > 0) {
            return first ? prefixes.get(0) : prefixes.iterator();
        }
        return null;
    }

    public void addEntry(String prefix, String uri) {
        List<String> listOfPrefix;
        if (this.contextWithURIKey == null) {
            this.contextWithURIKey = new Hashtable<String, List<String>>();
        }
        if (this.contextWithPrefixKey == null) {
            this.contextWithPrefixKey = new Hashtable<String, String>();
        }
        if ((listOfPrefix = this.contextWithURIKey.get(uri)) == null) {
            listOfPrefix = new ArrayList<String>();
            this.contextWithURIKey.put(uri, listOfPrefix);
        }
        listOfPrefix.add(prefix);
        this.contextWithPrefixKey.put(prefix, uri);
    }

    public void addEntries(MappedNamespaceContext mappedNamespaceContext) {
        String[] prefixes = mappedNamespaceContext.getPrefixes();
        int i = 0;
        while (i < prefixes.length) {
            this.addEntry(prefixes[i], mappedNamespaceContext.getNamespaceURI(prefixes[i]));
            ++i;
        }
    }

    public String[] getNamespaces() {
        return this.contextWithURIKey.keySet().toArray(new String[this.contextWithURIKey.size()]);
    }

    public String[] getPrefixes() {
        return this.contextWithPrefixKey.keySet().toArray(new String[this.contextWithPrefixKey.size()]);
    }

    public void clear() {
        this.contextWithURIKey.clear();
        this.contextWithPrefixKey.clear();
    }
}

