/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrackerDataBuilder<T>
extends AbstractDataBuilder<T> {
    private static int START = 0;
    private static int OPEN = 1;
    private static int CLOSE = 2;
    private List<Integer> documentNodeInx = new ArrayList<Integer>();
    private int lastEvent;
    private int orphanInx = -1;

    @Override
    public void initialize(Map<String, Object> init) {
        super.initialize(init);
        this.documentNodeInx.clear();
        this.lastEvent = START;
        String[] aliases = this.getAliases();
        this.orphanInx += aliases == null || aliases.length <= 0 ? 1 : 0;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.lastEvent == OPEN || this.lastEvent == START) {
            this.documentNodeInx.add(0);
        } else if (this.lastEvent == CLOSE) {
            int lastInx = this.documentNodeInx.size() - 1;
            this.documentNodeInx.set(lastInx, this.documentNodeInx.get(lastInx) + 1);
        }
        this.lastEvent = OPEN;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.lastEvent == CLOSE) {
            this.documentNodeInx.remove(this.documentNodeInx.size() - 1);
        }
        this.lastEvent = CLOSE;
    }

    protected int[] getNodePath() {
        int[] nodePath = new int[this.documentNodeInx.size()];
        int j = 0;
        while (j < nodePath.length) {
            nodePath[j] = this.documentNodeInx.get(j);
            ++j;
        }
        return nodePath;
    }

    public static Node findNode(Node startingNode, int[] indices) {
        Node currentNode = startingNode;
        NodeList nodeList = null;
        int i = 1;
        while (i < indices.length) {
            nodeList = currentNode.getChildNodes();
            if (indices[i] < 0 || indices[i] >= nodeList.getLength()) {
                return null;
            }
            currentNode = nodeList.item(indices[i]);
            ++i;
        }
        return currentNode;
    }

    protected int getOrphanInx() {
        return this.orphanInx;
    }
}

