/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.net.URI;
import java.util.Stack;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.artifacts.AcyclicStructure;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractTrackerDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcyclicDataBuilder
extends AbstractTrackerDataBuilder<AcyclicStructure> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.AcyclicDataTypesList";
    private Stack<AcyclicStructure.AcyclicEntry> acyclicElements = new Stack();
    private boolean storeReference;
    private StringBuffer characterBuffer;
    private AcyclicStructure acyclicTypeStructure = new AcyclicStructure();

    public AcyclicDataBuilder() {
        super.addEvent(1);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (!this.acyclicElements.isEmpty()) {
            if ("http://www.w3.org/ns/sml".equals(uri) && "uri".equals(localName)) {
                this.characterBuffer = new StringBuffer();
                this.storeReference = true;
            }
            return;
        }
        AbstractDataBuilder.AnnotationResult annotationResult = SMLValidatorUtil.retrieveAnnotation(this.getPsvi(), "http://www.w3.org/ns/sml", "acyclic", true);
        if (annotationResult == null) {
            return;
        }
        String acylicValue = annotationResult.getNodes()[0].getNodeValue();
        if (SMLValidatorUtil.isTrue(acylicValue) && this.isAttributeSet(attributes, "http://www.w3.org/ns/sml", "ref") && !this.isAttributeSet(attributes, "http://www.w3.org/ns/sml", "nilref")) {
            AcyclicStructure.AcyclicEntry acyclicEntry = new AcyclicStructure.AcyclicEntry();
            acyclicEntry.setURI(uri);
            acyclicEntry.setLocalName(localName);
            acyclicEntry.setType((XSComplexTypeDefinition)annotationResult.getType());
            acyclicEntry.setLineNumber(this.getBaseLineNumber() + this.getLocator().getLineNumber() - 1);
            acyclicEntry.setAliases(this.getAliases());
            acyclicEntry.setNodePath(this.getNodePath());
            acyclicEntry.setDocumentPosition(this.getOrphanInx());
            this.acyclicElements.push(acyclicEntry);
        }
    }

    private boolean isAttributeSet(Attributes attributes, String uri, String localName) {
        String value = attributes.getValue(uri, localName);
        Boolean bValue = value == null ? false : SMLValidatorUtil.isTrue(value);
        return bValue;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        if (!this.storeReference) {
            return;
        }
        String str = new String(chars, start, length);
        this.characterBuffer.append(str.trim());
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        URI saveCurrentBaseURI = this.getCurrentBaseURI();
        super.endElement(uri, localName, name);
        if (this.acyclicElements.isEmpty()) {
            return;
        }
        AcyclicStructure.AcyclicEntry topAcyclicEntry = this.acyclicElements.peek();
        if (this.storeReference && "http://www.w3.org/ns/sml".equals(uri) && "uri".equals(localName)) {
            this.storeReference = false;
        } else if (this.isEqual(uri, topAcyclicEntry.getURI()) && this.isEqual(localName, topAcyclicEntry.getLocalName())) {
            this.acyclicElements.pop();
            String candidateRef = this.characterBuffer == null ? "" : this.characterBuffer.toString();
            int lineNum = this.getLocator() == null ? -1 : this.getLocator().getLineNumber();
            String nonRelativeReference = URIReference.validURIReference(candidateRef, saveCurrentBaseURI, this.getMessageOutputter(), lineNum, SMLValidationMessages.smlReference);
            topAcyclicEntry.setReference(nonRelativeReference);
            this.acyclicTypeStructure.add(topAcyclicEntry.getType(), topAcyclicEntry);
        }
    }

    private boolean isEqual(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    @Override
    public AcyclicStructure getDataStructure() {
        return this.acyclicTypeStructure;
    }
}

