/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;

/**
 * Constants for registration & deregistration transformers.
 * All constants that are shared with the query service
 * can be found in the ICMDBfServicesConstants interface.
 * 
 * 
 * @see ICMDBfServicesConstants
 * @author David Whiteman
 */
public interface IRegistrationTransformerConstants {

	public static final String DEREGISTER_REQUEST_ELEMENT = "deregisterRequest";
	public static final String ITEM_ID_LIST_ELEMENT = "itemIdList";
	public static final String ITEM_LIST_ELEMENT = "itemList";
	public static final String REGISTER_REQUEST_ELEMENT = "registerRequest";
	public static final String RELATIONSHIP_ID_LIST_ELEMENT = "relationshipIdList";
	public static final String RELATIONSHIP_LIST_ELEMENT = "relationshipList";
	public static final String ACCEPTED_ELEMENT = "accepted";
	public static final String DECLINED_ELEMENT = "declined";
	public static final String REASON_ELEMENT = "reason";
	public static final String INSTANCE_RESPONSE_ELEMENT = "instanceResponse";
	public static final String REGISTER_RESPONSE_ELEMENT = "registerResponse";
	public static final String ALTERNATE_INSTANCE_ID_ELEMENT = "alternateInstanceId";
	public static final String DEREGISTER_RESPONSE_ELEMENT = "deregisterResponse";
	public static final String CDATA_PREFIX = "<![CDATA[";
	public static final String CDATA_SUFFIX = "]]>";
}
