/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <serviceDescription> element in XML form
 * 
 * 
 * @author Bill Muldoon
 */
public interface IServiceDescription extends IXMLWritable
{
	/**
	 * set the mdrId of the ServiceDescription
	 * 
	 * @param mdrId
	 */
	public void setMdrId(String mdrId);
		
	/**
	 * Retrieve an mdrId
	 * 
	 * @return mdrId
	 */
	public String getMdrId();

	
	/**
	 * set the description of the ServiceDescription
	 * 
	 * @param description
	 */
	public void setDescription(String description);
		
	/**
	 * Retrieve a description
	 * 
	 * @return String description
	 */
	public String getDescription();


}
