/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.reference;

/**
 * The SML XPath1 scheme is used to evaluate the parenthesized expressions that
 * appears after the keyword smlxpath1 in an XPointer expression.
 * 
 * @author Ali Mehregani
 */
public class SMLXPath1Scheme extends AbstractScheme
{
	/**
	 * Represents the keyword to identify this scheme
	 */
	public static final String SCHEME = "smlxpath1";

	
	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.reference.IXScheme#getType()
	 */
	public String getType()
	{		
		return SCHEME;
	}

}
