/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Common data regarding a record. This is represented by the <recordMetadata>
 * element that is a child of a <record> element in a query response.
 * 
 * 
 * @author David Whiteman
 */
public interface IRecordMetadata extends IXMLWritable {
	/**
	 * Answer the name or other identifier used to group records into a
	 * particular baseline configuration. A value of "0" indicates that this
	 * record is not part of any baseline configuration.
	 * 
	 * @return
	 */
	public String getBaselineId();

	/**
	 * Answer the time/date the record was last modified in ISO 8601 format.
	 * 
	 * @return
	 */
	public String getLastModified();

	/**
	 * Answer the unique Id of the record in the MDR. This will correspond to
	 * the IRecord that contains this metadata.
	 * 
	 * @return
	 */
	public URI getRecordId();
	

	/**
	 * Answer the name or other identifier used to group records observed in a
	 * configuration snapshot (discovery). A value of "0" indicates that this
	 * record is not part of any snapshot configuration.
	 * 
	 * @return
	 */
	public String getSnapshotId();

	/**
	 * Answer any extensibility elements not defined by the spec.
	 * 
	 * @return
	 */
	public IXMLWritable getExtensibilityElements();

	/**
	 * Set the name or other identifier used to group records into a particular
	 * baseline configuration. A value of "0" indicates that this record is not
	 * part of any baseline configuration.
	 * 
	 * @param baselineId
	 */
	public void setBaselineId(String baselineId);

	/**
	 * Set the time/date the record was last modified in ISO 8601 format. The
	 * applicable time zone or UTC MUST be indicated.
	 * 
	 * @param date
	 */
	public void setLastModified(String date);

	/**
	 * Set the unique Id of the record in the MDR. This will correspond to the
	 * IRecord that contains this metadata.
	 * 
	 * @param uri
	 */
	public void setRecordId(URI uri);

	/**
	 * Set the name or other identifier used to group records observed in a
	 * configuration snapshot (discovery). A value of "0" indicates that this
	 * record is not part of any snapshot configuration.
	 * 
	 * @param snapshotId
	 */
	public void setSnapshotId(String snapshotId);

	/**
	 * Set extensibility elements not defined by the spec.
	 * 
	 * @param value
	 */
	public void setExtensibilityElements(IXMLWritable value);

	/**
	 * Set extensibility elements not defined by the spec, from a raw String
	 * input.
	 * 
	 * @param stringRepresentationOfValue
	 */
	public void setExtensibilityElementsFromString(
			String stringRepresentationOfValue);

}
