/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * Represents the <instanceIdConstrating> element for querying the MDR for data
 * based on one or more MDR-scoped instanceIds.
 * 
 * 
 * @author David Whiteman
 */
public interface IInstanceIdConstraint extends IConstraint, IXMLWritable {
	/**
	 * Answer the set of instance ids being used for this constraint
	 * 
	 * @return
	 */
	public IInstanceId[] getInstanceIds();

	/**
	 * Add an instance id to the constraint
	 * 
	 * @param instanceId
	 */
	public void addInstanceId(IInstanceId instanceId);
}
