/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.application;

import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocumentFragment;

/**
 * Represents a property which is a strongly typed SML
 * document fragment.  A facet contains
 * 
 * @author Ali Mehregani
 */
public interface ISMLResourceProperty extends ISMLDocumentFragment, ISMLResourceBase
{
	/**
	 * If this object happens to represent a reference to a property
	 * (i.e. isReference() returns true), then this method will have it
	 * resolved to the actual property.  If isReference() happens to
	 * return false, then the return value of this method is this
	 * object.
	 * 
	 * @return An object representing the resolved property that 
	 * this reference points to 
	 */
    public ISMLResourceProperty resolveReference();
    
    
    /**
     * Returns the property name of this object
     * 
     * @return the property name
     */
    public String retrievePropertyName();
    
    
    /**
     * Retrieves the children of this property if it has any
     * An empty array is returned if this property does not have any
     * children.
     * 
     * @return The children of this property
     */
    public ISMLResourceProperty[] retrieveChildren();
    
    
    /**
     * Retrieves and returns the attributes of this property
     * 
     * @return The attributes of this property
     */ 
    public String[] retrieveAttributes();
    
    
    /**
     * Retrieves the value of the attribute with the name that
     * is passed in.
     * 
     * @param attribute The attribute name
     * @return The value if of the attribute if it exists; null othewise
     */
    public String retrieveValue(String attribute);
}
