/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.smlif.export.ui;

import org.eclipse.cosmos.rm.internal.repository.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.internal.smlif.SMLImages;
import org.eclipse.cosmos.rm.internal.validation.artifacts.RuleBinding;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/**
 * Label provider for displaying rows in rule binding table
 * 
 * @author David Whiteman
 */
public class RuleBindingTableLabelProvider extends LabelProvider implements
		ITableLabelProvider {

	public Image getColumnImage(Object element, int columnIndex) {
		// Need an icon for added bindings so they can be distinguished from
		// empty rows
		if (columnIndex == 0) {
			return SMLImages.INSTANCE.getImage(SMLImages.RULEBINDING);
		}
		return null;
	}

	public String getColumnText(Object element, int columnIndex) 
	{
		Object modelDataForColumn = getModelDataForColumn(element, columnIndex);
		
		if (modelDataForColumn instanceof ISMLDocument)
			return SMLRepositoryUtil.getDocumentName((ISMLDocument)modelDataForColumn);
		
		return modelDataForColumn == null ? "" : modelDataForColumn.toString();
	}

	public static Object getModelDataForColumn(Object element, int columnIndex) {
		RuleBinding ruleBinding = (RuleBinding) element;
		switch (columnIndex) {
		case 0:
			return ruleBinding.getAlias();
		case 1:
			return ruleBinding.getRule();
		default:
			return "unknown " + columnIndex;
		}
	}
	
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

}
