/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.cosmos.me.sdd.schema.ArgumentListType;
import org.eclipse.cosmos.me.sdd.schema.ArgumentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.eclipse.cosmos.me.sdd.schema.registry.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.registry.ProductType;
import org.eclipse.cosmos.me.sdd.schema.registry.RegistryType;
import org.eclipse.cosmos.me.sdd.schema.registry.VersionType;
import org.osgi.service.log.LogService;

public class SDDRegistry {
    private static String FOLDER = "C:\\TEMP\\";
    private static String SDD_FOLDER = "registry_files";
    private static final String FILENAME = "registry.xml";

    private static String getFolder() {
        return FOLDER;
    }

    private static void setFolder(String folder) {
        FOLDER = folder;
    }

    protected static void updateRegistry(SDDContext ctxt, ArtifactType artifact, LogService logService) {
        SDDRegistry.setFolder(SDDRegistry.deriveFolder());
        RegistryType registry = null;
        ObjectFactory of = new ObjectFactory();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RegistryType.class});
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement installJax = u.unmarshal((Source)new StreamSource(String.valueOf(SDDRegistry.getFolder()) + FILENAME), RegistryType.class);
            registry = (RegistryType)installJax.getValue();
        }
        catch (JAXBException jAXBException) {
            logService.log(3, "unable to unmarshal install.xml");
        }
        if (registry == null) {
            registry = of.createRegistryType();
        }
        registry.setVersion(new Date().toString());
        ProductType prod = of.createProductType();
        VersionType vers = of.createVersionType();
        vers.setMajor(ctxt.getPackageDescriptor().getPackageIdentity().getVersion());
        prod.setVersion(vers);
        prod.setId(ctxt.getPackageDescriptor().getPackageIdentity().getSoftwareID());
        prod.setName(ctxt.getPackageDescriptor().getPackageIdentity().getDescription().getValue());
        prod.setPath(SDDRegistry.getInstallLoc(ctxt, artifact));
        prod.setSddPath(SDDRegistry.copyFile(ctxt.getPackageUri()));
        prod.setSpdPath(SDDRegistry.copyFile(ctxt.getDeploymentDescriptorUri()));
        registry.getProduct().add(prod);
        SDDRegistry.marshalRegistry(registry);
    }

    private static String deriveFolder() {
        return String.valueOf(System.getProperty("user.home")) + File.separator;
    }

    private static void marshalRegistry(RegistryType registry) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RegistryType.class});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            m.marshal((Object)registry, (OutputStream)new FileOutputStream(String.valueOf(SDDRegistry.getFolder()) + FILENAME));
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static String getInstallLoc(SDDContext ctxt, ArtifactType artifact) {
        if (artifact.getArguments() != null) {
            ArgumentListType arguments = artifact.getArguments();
            for (ArgumentType argument : arguments.getArgument()) {
                if (!argument.getName().equalsIgnoreCase("installLoc")) continue;
                return ctxt.substituteVariables(argument.getValue());
            }
        }
        return null;
    }

    private static String copyFile(String path) {
        try {
            int len;
            new File(String.valueOf(SDDRegistry.getFolder()) + SDD_FOLDER).mkdirs();
            File file = new File(path);
            File file2 = new File(String.valueOf(SDDRegistry.getFolder()) + SDD_FOLDER + File.separator + file.getName());
            FileInputStream in = new FileInputStream(file);
            FileOutputStream out = new FileOutputStream(file2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return String.valueOf(SDDRegistry.getFolder()) + SDD_FOLDER + File.separator + file.getName();
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return null;
    }
}

