/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.schema.ext;

import java.util.HashMap;
import java.util.Map.Entry;


/**
 * Class that contains the resolutions from resolving a SDD.
 *
 */
public class ResolutionModel {

	private String _id;
	private HashMap<String,ResolutionObject> _resolutions = new HashMap<String, ResolutionObject>();
	private HashMap<String,ResolutionObject> _resultingResources = new HashMap<String, ResolutionObject>();
	private HashMap<String,ResolutionObject> _artifacts = new HashMap<String, ResolutionObject>();
	
	/**
	 * Constructor
	 */
	public ResolutionModel() {
		
	}
	public ResolutionModel(String id) {
		_id = id;
	}
	
	public void setId(String id) {
		_id = id;
	}
	public String getId() {
		return _id;
	}
	
	public HashMap<String,ResolutionObject> getResolutions() {
		return _resolutions;
	}
	public HashMap<String,ResolutionObject> getResultingResources() {
		return _resultingResources;
	}
	public HashMap<String,ResolutionObject> getArtifacts() {
		return _artifacts;
	}
	
	public void addResolutionObject(String key, ResolutionObject value) {
		_resolutions.put(key, value);
	}
	
	public ResolutionObject getResolutionObject(String key) {
		return _resolutions.get(key);
	}
	
	public void unresolve(String key) {
		if(getResolutionObject(key) != null) {
			getResolutionObject(key).unresolve();
		}
	}
	
	public void resolve(String key) {
		if(getResolutionObject(key) != null) {
			getResolutionObject(key).resolve();
		}
	}
	
	public void accept(String key) {
		if(getResolutionObject(key) != null) {
			getResolutionObject(key).accept();
		}
	}
	
	public void reject(String key) {
		if(getResolutionObject(key) != null) {
			getResolutionObject(key).reject();
		}
	}
	
	public void addResultingResource(String key, ResolutionObject value) {
		_resultingResources.put(key, value);
	}
	
	public void addArtifact(String key, ResolutionObject value) {
		_artifacts.put(key, value);
	}
	
	public boolean isResolved() {
		for (ResolutionObject ro : _resolutions.values()) {
			if (!ro.isResolved()) return false;
		}
		for (ResolutionObject ro : _resultingResources.values()) {
			if (!ro.isResolved()) return false;
		}
		for (ResolutionObject ro : _artifacts.values()) {
			if (!ro.isResolved()) return false;
		}
		return true;
	}
	
	public boolean isUnresolved() {
		for (ResolutionObject ro : _resolutions.values()) {
			if (ro.isUnresolved()) return true;
		}
		for (ResolutionObject ro : _resultingResources.values()) {
			if (ro.isUnresolved()) return true;
		}
		for (ResolutionObject ro : _artifacts.values()) {
			if (ro.isUnresolved()) return true;
		}
		return false;
	}
	
	@Override
	public String toString() {
		String nl = "\n";
		StringBuilder s = new StringBuilder();
		s.append("ResolutionModel: ").append(_id).append(nl);
		
		s.append("==========\n");
		s.append("resolutions\n");
		for (Entry<String, ResolutionObject> e : _resolutions.entrySet()) {
			s.append("----------\n");
			s.append(e.getValue().toString());
		}
		
		s.append("==========\n");
		s.append("resulting resources\n");
		for (Entry<String, ResolutionObject> e : _resultingResources.entrySet()) {
			s.append("----------\n");
			s.append(e.getValue().toString());
		}
		
		s.append("==========\n");
		s.append("artifacts\n");
		for (Entry<String, ResolutionObject> e : _artifacts.entrySet()) {
			s.append("----------\n");
			s.append(e.getValue().toString());
		}
		return s.toString();
	}
}
