/*******************************************************************************
 * Copyright (c) 2009 CA, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA, Inc. - initial API and implementation
 *     SAS Institute, Inc. - Bug 275731
 *******************************************************************************/
package org.eclipse.cosmos.me.sdd.cr.impl;

import java.text.MessageFormat;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class ResourceHandlerImpl implements ResourceHandler {
	static final String QUERY = "("+IResourceHandler.QNAME+"={0})";
	private BundleContext context;
	
	protected void activate(ComponentContext ctxt) {
		context = ctxt.getBundleContext();
	}
	
	protected void deactivate(ComponentContext ctxt) {
		context = null;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			CapacityConstraintType constraint) {
		boolean result = false;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.evaluate(ctxt, rsrc, constraint);
			}
			context.ungetService(ref);
		}
		return result;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			ConsumptionConstraintType constraint) {
		boolean result = false;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.evaluate(ctxt, rsrc, constraint);
			}
			context.ungetService(ref);
		}
		return result;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			PropertyConstraintType constraint) {
		boolean result = false;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.evaluate(ctxt, rsrc, constraint);
			}
			context.ungetService(ref);
		}
		return result;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			ConditionalPropertyConstraintType constraint) {
		boolean result = false;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.evaluate(ctxt, rsrc, constraint);
			}
			context.ungetService(ref);
		}
		return result;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			VersionConstraintType constraint) {
		boolean result = false;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.evaluate(ctxt, rsrc, constraint);
			}
			context.ungetService(ref);
		}
		return result;
	}
	
	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			RequirementResourceConstraintType constraint) {
		boolean result = false;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.evaluate(ctxt, rsrc, constraint);
			}
			context.ungetService(ref);
		}
		return result;
	}

	public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname) {
		Object result = null;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.getPropertyValue(ctxt, rsrc, qname);
			}
			context.ungetService(ref);
		}
		return result;
	}
	
	public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
		Object result = null;
		ServiceReference ref = lookup(rsrc.getType());
		if (ref != null) {
			IResourceHandler rh = (IResourceHandler) context.getService(ref);
			if (rh != null) {
				result = rh.getVersionValue(ctxt, rsrc);
			}
			context.ungetService(ref);
		}
		return result;
	}
	
	private ServiceReference lookup(QName qname) {
		ServiceReference ref = null;
		String query = MessageFormat.format(QUERY, qname);
		try {
			ServiceReference[] refs = context.getServiceReferences(IResourceHandler.class.getName(), query);
			if (refs != null && refs.length > 0) {
				ref = refs[0];
			}
		} catch (InvalidSyntaxException e) {
			return null;
		}
		
		return ref;
	}
}
