/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.op.listener;

/**
 * Interface that defines a listener for events that happen during installation.
 */
public interface InstallationProgressListener extends InstallListener {

	public void progressBeginningAction(String action, EntryData metaData); 
	// action is one of OperationController.ADDED_FILE, OperationController.REMOVED_FILE, or OperationController.DELETED_FILE
	
	public void progressBeginningAction(String description);
	
	public void progressCompleteAction(String action, EntryData metaData); 
	// action is one of OperationController.ADDED_FILE, OperationController.REMOVED_FILE, or OperationController.DELETED_FILE
	
	public void progressFailedAction(String action, EntryData metaData);
	
	public void progressCompleteAction(String description);
	
	public void bytesMoved(long numBytes);
}
