/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import org.eclipse.cosmos.me.sdd.schema.BaseContentType;
import org.eclipse.cosmos.me.sdd.schema.CompositeInstallableType;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.InstallableUnitCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.TopologyCompare;

public class DeploymentDescriptorCompare {
    protected static DeploymentDescriptorType merge(DeploymentDescriptorType dd1, DeploymentDescriptorType dd2) {
        ObjectFactory objectFactory = new ObjectFactory();
        DeploymentDescriptorType mergedDD = objectFactory.createDeploymentDescriptorType();
        mergedDD.setSchemaVersion(dd1.getSchemaVersion());
        mergedDD.setDescriptorID(dd1.getDescriptorID());
        mergedDD.setLastModified(dd1.getLastModified());
        mergedDD.setDescriptorLanguageBundle(StringCompare.merge(dd1.getDescriptorLanguageBundle(), dd2.getDescriptorLanguageBundle()));
        mergedDD.setTopology(TopologyCompare.merge(dd1.getTopology(), dd2.getTopology()));
        InstallableUnitType iu = InstallableUnitCompare.merge(dd1.getInstallableUnit(), dd2.getInstallableUnit());
        if (iu != null) {
            mergedDD.setInstallableUnit(iu);
        } else {
            CompositeInstallableType ci = objectFactory.createCompositeInstallableType();
            BaseContentType bc = objectFactory.createBaseContentType();
            bc.getInstallableUnitOrConfigurationUnitOrCompositeUnit().add(dd1);
            bc.getInstallableUnitOrConfigurationUnitOrCompositeUnit().add(dd2);
            ci.setBaseContent(bc);
            mergedDD.getCompositeInstallable().add(ci);
        }
        return mergedDD;
    }
}

