/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.InternalDependencyType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.AlternativeRequirementCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.InternalDependencyCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.OperationCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementCompare {
    protected static Vector<RequirementType> merge(List<RequirementType> rs, List<RequirementType> rs2) {
        Vector<RequirementType> toRemove = new Vector<RequirementType>();
        for (RequirementType o1 : rs) {
            for (RequirementType o2 : rs2) {
                if (toRemove.contains(o2) || !RequirementCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = RequirementCompare.merge(o1, o2);
            }
        }
        rs2.removeAll(toRemove);
        Vector<RequirementType> finals = new Vector<RequirementType>();
        finals.addAll(rs);
        finals.addAll(rs2);
        return finals;
    }

    protected static RequirementType merge(RequirementType o1, RequirementType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        RequirementType r = objectFactory.createRequirementType();
        r.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        r.setDisplayName(DisplayTextCompare.merge(o1.getDisplayName(), o2.getDisplayName()));
        r.setId(o1.getId());
        r.getOperation().addAll(o1.getOperation());
        r.getAlternative().addAll(AlternativeRequirementCompare.merge(o1.getAlternative(), o2.getAlternative()));
        r.getResourceConstraintOrDependencyOrAny().addAll(o1.getResourceConstraintOrDependencyOrAny());
        r.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        return r;
    }

    protected static boolean equals(RequirementType r, RequirementType r2) {
        if (!OperationCompare.equals(r.getOperation(), r2.getOperation())) {
            return false;
        }
        Vector<RequirementResourceConstraintType> rcs = new Vector<RequirementResourceConstraintType>();
        Vector<RequirementResourceConstraintType> rcs2 = new Vector<RequirementResourceConstraintType>();
        Vector<InternalDependencyType> ids = new Vector<InternalDependencyType>();
        Vector<InternalDependencyType> ids2 = new Vector<InternalDependencyType>();
        for (Object o : r.getResourceConstraintOrDependencyOrAny()) {
            if (o instanceof RequirementResourceConstraintType) {
                rcs.add((RequirementResourceConstraintType)o);
            }
            if (!(o instanceof InternalDependencyType)) continue;
            ids.add((InternalDependencyType)o);
        }
        for (Object o : r2.getResourceConstraintOrDependencyOrAny()) {
            if (o instanceof RequirementResourceConstraintType) {
                rcs2.add((RequirementResourceConstraintType)o);
            }
            if (!(o instanceof InternalDependencyType)) continue;
            ids2.add((InternalDependencyType)o);
        }
        return InternalDependencyCompare.equals(ids, ids2);
    }
}

