/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.DerivedVariableType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ConditionalDerivedVariableExpressionCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedVariableCompare {
    protected static Vector<DerivedVariableType> merge(List<DerivedVariableType> params, List<DerivedVariableType> params2) {
        Vector<DerivedVariableType> toRemove = new Vector<DerivedVariableType>();
        for (DerivedVariableType o1 : params) {
            for (DerivedVariableType o2 : params2) {
                if (toRemove.contains(o2) || !DerivedVariableCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = DerivedVariableCompare.merge(o1, o2);
            }
        }
        params2.removeAll(toRemove);
        Vector<DerivedVariableType> finals = new Vector<DerivedVariableType>();
        finals.addAll(params);
        finals.addAll(params2);
        return finals;
    }

    private static boolean equals(DerivedVariableType o1, DerivedVariableType o2) {
        if (o1.isSensitive() != o2.isSensitive()) {
            return false;
        }
        return StringCompare.equals(o1.getExpression(), o2.getExpression());
    }

    protected static DerivedVariableType merge(DerivedVariableType o1, DerivedVariableType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        DerivedVariableType merged = objectFactory.createDerivedVariableType();
        merged.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        merged.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        merged.getConditionalExpression().addAll(ConditionalDerivedVariableExpressionCompare.merge(o1.getConditionalExpression(), o2.getConditionalExpression()));
        return merged;
    }
}

