package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.LanguageType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;

public class LanguageCompare
{

	protected static Collection<? extends LanguageType> merge(List<LanguageType> l, List<LanguageType> l2)
	{
		Vector <LanguageType> toRemove = new Vector <LanguageType> ();
		Iterator <LanguageType> iter1 = l.iterator();		
		//iterate through the items
		while (iter1.hasNext())
		{
			LanguageType o1 = (LanguageType) iter1.next();
			Iterator <LanguageType> iter2 = l2.iterator();
			while (iter2.hasNext())
			{
				LanguageType o2 = (LanguageType) iter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (toRemove.contains(o2)==false)
				{
					if (equals(o1, o2))
					{  
						toRemove.add(o2);
						o1 = merge(o1,o2);
					}
				}
					
			}
		}
		
		l2.removeAll(toRemove);
		//remove all of the matches that were found
		
		Vector <LanguageType> finals = new Vector <LanguageType> ();
		//create and return a new collection with all of the remaining items
		finals.addAll(l);
		finals.addAll(l2);		
		
		return finals;
	}

//	<LanguageType> 	 	 	 	
//	type 	xsd:language 	Yes
//DisplayElementGroup 		DisplayElementGroup 	Merge 
	
	protected static LanguageType merge(LanguageType o1,	LanguageType o2)
	{
		ObjectFactory objectFactory = new ObjectFactory();
		LanguageType merged = objectFactory.createLanguageType();
		merged.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
		merged.setDisplayName(DisplayTextCompare.merge(o1.getDisplayName(), o2.getDisplayName()));
		merged.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
		merged.setType(o1.getType());
		return merged;
	}

	protected static boolean equals(LanguageType l, LanguageType l2)
	{
		if (!StringCompare.equals(l.getType(), l2.getType()))
			return false;
		return true;
	}

}