/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.sdd.tooling.btg.SDDFragment;

public class Aggregator implements IBTGDataAggregator {
    Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");//$NON-NLS-1$
    Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");//$NON-NLS-1$
    static private DeploymentDescriptorType dd1;
	static private DeploymentDescriptorType dd2;
	
	static private PackageDescriptorType pd1;
	static private PackageDescriptorType pd2;
    
    
	public Collection<BTGProperty> getSupportedProperties() {
		List<BTGProperty> properties = new ArrayList<BTGProperty>();
		
				
		return properties;
	}

	
	public Collection<Object> aggregateSDDData(
			Collection<SDDFragment> fragments, Properties properties,
			boolean allowIncompleteSDDs) {
		
		try
		{	
			consoleLogger.info("welcome to the aggregator");
			
			if (fragments.size()!=0)
			{
				
				Iterator <SDDFragment> sddIter = fragments.iterator();
				DeploymentDescriptorType resultingDD = sddIter.next().getFragment().getValue();
				while (sddIter.hasNext())
				{
					dd1 = resultingDD;
					dd2 = sddIter.next().getFragment().getValue();
					resultingDD = DeploymentDescriptorCompare.merge(dd1,dd2);
					
				}
				
				// Prepare the document for writing
				
				
				Collection<Object> returnArray = new ArrayList<Object>();
				returnArray.add(resultingDD);
				writeSDD(resultingDD);
				
				return returnArray;
			}
			else
			{
				consoleLogger.info("No fragments passed to aggregator");
				return null;
			}

		}
		catch (Exception e)
		{ 
			e.printStackTrace();
			return null;
		}
				
	}
	
	public static void writeSDD(DeploymentDescriptorType doc)
	{
		String outputLocation = "C:\\";
		try
		{
			JAXBContext uninstallJc = JAXBContext.newInstance("org.eclipse.cosmos.me.sdd.schema");
	    	Marshaller m = uninstallJc.createMarshaller();
	    	m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, new Boolean(true));
	    	m.marshal(doc, new FileOutputStream(outputLocation+"outputSDD.xml"));
	        
	    }
		catch( JAXBException je )
		{
	        je.printStackTrace();
	    } catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
	    }
	}
	
	public static DeploymentDescriptorType getDd1()
	{
		return dd1;
	}
	
	public static DeploymentDescriptorType getDd2()
	{
		return dd2;
	}
	
	public static boolean setDd1(DeploymentDescriptorType dd)
	{
		try
		{
			dd1 = dd;
			return true;
		}
		catch (Exception e)
		{
			return false;
		}
	}
	
	public static boolean setDd2(DeploymentDescriptorType dd)
	{
		try
		{
			dd2 = dd;
			return true;
		}
		catch (Exception e)
		{
			return false;
		}
	}
	
	public static Collection<DeploymentDescriptorType> getAllDeploymentDescriptors()
	{
		Collection<DeploymentDescriptorType> deploymentDescriptors = new ArrayList<DeploymentDescriptorType>();
		deploymentDescriptors.add(getDd1());
		deploymentDescriptors.add(getDd2());
		
		return deploymentDescriptors;
		
	}
	
	public static PackageDescriptorType getPd1()
	{
		return pd1;
	}
	
	public static PackageDescriptorType getPd2()
	{
		return pd2;
	}
	
	public static boolean setPd1(PackageDescriptorType pd)
	{
		try
		{
			pd1 = pd;
			return true;
		}
		catch (Exception e)
		{
			return false;
		}
	}
	
	public static boolean setPd2(PackageDescriptorType pd)
	{
		try
		{
			pd2 = pd;
			return true;
		}
		catch (Exception e)
		{
			return false;
		}
	}
	
	public static Collection<PackageDescriptorType> getAllPackageDescriptors()
	{
		Collection<PackageDescriptorType> packageDescriptors = new ArrayList<PackageDescriptorType>();
		packageDescriptors.add(getPd1());
		packageDescriptors.add(getPd2());
		
		return packageDescriptors;
		
	}

}




