/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore");
dojo.require("dojo.data.ItemFileWriteStore");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");

dojo.declare("org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore", dojo.data.ItemFileWriteStore, {
	_getItemsFromLoadedData: function(/* Object */ response){
		//need to catch errors from getting the store from a url
		if (response._error_){
			//no idea why I have to create a new error and not use the global 'cosmos' variable
			
			//need to decode string messages
			var detail = unescape(response.detail);
			var message = unescape(response.message);
			rExp = /\+/gi;
			response.detail=detail.replace(rExp, " ");				
			response.message=message.replace(rExp, " ");
			//log error
			dojo.publish("org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler", [{message:response, prompt:true, severity:1}]);
			this.responseError(response);
			if(keyArgs.onError){
					var scope = keyArgs.scope ? keyArgs.scope : dojo.global;
					keyArgs.onError.call(scope, response);
			}
			 
		}

		return org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore.superclass._getItemsFromLoadedData.apply(this, arguments);	
	},
	responseError:function(response){
	},
	getValues: function(/* item */ item, 
						/* attribute-name-string */ attribute, onComplete){
		//	summary: 
		//		See dojo.data.api.Read.getValues()

		if (onComplete){
			if (item.expandQuery){
					var queryObject = this.UIContext.createObject(item.expandQuery);
					if (queryObject != null){
						function onItem(citem){
							onComplete(citem.items);
						}
						this.UIContext.submitQuery({queryObject:queryObject, item:item, onItem:onItem});			
						return [];
					}
			}
			onComplete(org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore.superclass.getValues.apply(this, arguments));
			return [];
		}
		return org.eclipse.cosmos.provisional.dr.ps.components.data.LazyLoadStore.superclass.getValues.apply(this, arguments);
	},
	loadItem: function(/* object */ keywordArgs){
		//	summary: 
		//		See dojo.data.api.Read.loadItem()
		
		var item = keywordArgs.item;
		for (i in item) {
			if (!dojo.isArray(item[i])) {
				item[i] = [item[i]];
			}
		}
		newIdentity = this._arrayOfAllItems.length;		
		item[this._storeRefPropName] = this;		
		item[this._itemNumPropName] = newIdentity;
		this._itemsByIdentity[newIdentity] = item;
		this._arrayOfAllItems.push(item);		
		//Reset the item in the reference.  
		//Done processing!  Call the onItem, if any.
		if(keywordArgs.onItem){
			var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
			keywordArgs.onItem.call(scope, item);
		}
		
	}
});