/*
* Copyright (c) 2005-2008 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.dc.internal.stat.datamgr.client;

import java.util.Date;

import javax.xml.namespace.QName;

public class StatisticalObservation {
	
	private boolean isIntegral = false;
	private boolean isContinuous = false;
	private boolean isString = false;
	private boolean isNull = true;

	private long integralValue;
	private String stringValue;
	private double continuousValue;
	
	private String name;
	
	
	public StatisticalObservation(String name, Object observation){
		this.name = name;
		
		if(observation != null){
			isNull = false;
			Class observationClass = observation.getClass();
			if(Double.class.isAssignableFrom(observationClass)){
				continuousValue = (Double)observation;
				isContinuous = true;
			} else if(Float.class.isAssignableFrom(observationClass)){
				continuousValue = (Float)observation;
				isContinuous = true;
			}else if(Integer.class.isAssignableFrom(observationClass)){
				integralValue = (Integer)observation;
				isIntegral = true;
			}else if(Long.class.isAssignableFrom(observationClass)){
				integralValue = (Long)observation;
				isIntegral = true;
			}else {
				stringValue = observation.toString();
				isString = true;
			}
		}
	}
	
	public boolean isIntegralObservation(){
		return isIntegral;
	}
	
	public boolean isStringObservation(){
		return isString;
	}
	
	public boolean isContinuousObservation(){
		return isContinuous;
	}

	public long getIntegralValue(){
		return integralValue;
	}
	
	public void setIntegralValue(long integralValue){
		this.integralValue = integralValue;
	}

	public double getContinuousValue(){
		return continuousValue;
	}
	
	public void setContinuousValue(double continuousValue){
		this.continuousValue = continuousValue;
	}

	public String getStringValue(){
		return stringValue;
	}
	
	public void setStringValue(String stringValue){
		this.stringValue = stringValue;
	}
	
	public String getName(){
		return name;
	}
	
	public String toString(){
		String ret = name + " = ";
		if(isIntegral){
			ret = ret.concat(String.valueOf(integralValue));
		}else if(isContinuous){
			ret = ret.concat(String.valueOf(continuousValue));
		}else{
			ret = ret.concat(stringValue);
		}
		return ret;
	}

}
