/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalDataManagerClient;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalObservation;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalTuple;
import org.eclipse.cosmos.dc.internal.stat.datamgr.common.DataSourceKeyset;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class StatDataSourceOutputter extends AbstractOutputter {
	private Logger logger = Logger.getLogger(getClass());
	public void render(PrintWriter output, IParameters input) throws Exception {
		String title = input.getParameter("title"); //$NON-NLS-1$
		String prop = input.getParameter("prop"); //$NON-NLS-1$
		String eprparm = input.getParameter("epr"); //$NON-NLS-1$
		
		StatisticalDataManagerClient dmc = new StatisticalDataManagerClient (eprparm);
		
		if ( prop != null && prop.equalsIgnoreCase("true")){ //$NON-NLS-1$
			boolean err = false;
			Collection<StatisticalTuple> st_coll = null;
 			try {
 				st_coll = dmc.getStatDataForSource(title,"TomcatSet",0,1000); //$NON-NLS-1$
 			} catch (CosmosException ex) {
 				err = true;
 				throw new CosmosException(Messages.getString("StatDataSourceOutputter.5"), ex); //$NON-NLS-1$
			}
 			if (!err) {
 				if (st_coll != null) {
 					Iterator I_st = st_coll.iterator();
 					
 					output.print("["); //$NON-NLS-1$
 					
 					while (I_st.hasNext()) {
 						StatisticalTuple st = (StatisticalTuple) I_st.next();
 						StatisticalObservation so_arr[] = st.getObservations();
 						Date st_date = st.getTimeStamp();
 						
 						output.print("	[ \"Date\", '" + st_date + "'],"); //$NON-NLS-1$ //$NON-NLS-2$
 						int so_count = 0;
 						for(StatisticalObservation so: so_arr){
 							output.print("	[ \"Name\", '" + so.getName() + "'],"); //$NON-NLS-1$ //$NON-NLS-2$
 							if (so.isContinuousObservation())
 								output.print("	[ \"Value\", '" + so.getContinuousValue() + "']"); //$NON-NLS-1$ //$NON-NLS-2$
 							else if (so.isIntegralObservation())
 								output.print("	[ \"Value\", '" + so.getIntegralValue() + "']"); //$NON-NLS-1$ //$NON-NLS-2$
 							else
 								output.print("	[ \"Value\", '" + so.getStringValue() + "']"); //$NON-NLS-1$ //$NON-NLS-2$
 							
 							if((so_count++ < so_arr.length) )
 								output.print(","); //$NON-NLS-1$
 						}

 						if(I_st.hasNext())
 							output.print(","); //$NON-NLS-1$
 						
 						System.out.println(st.toString());
 					}

 					output.print("]"); //$NON-NLS-1$
 				}
 				else
 					logger.info(Messages.getString("StatDataSourceOutputter.20")); //$NON-NLS-1$
 			}
		} else {
			// get the data source keysets from the CBE Data Manager client
			Collection<DataSourceKeyset> dsk_coll = null;
			
			try {
				if (dmc != null) dsk_coll = dmc.getDatasourceKeyset();
			} catch(CosmosException ex) {
 				throw new CosmosException(Messages.getString("StatDataSourceOutputter.21"), ex); //$NON-NLS-1$
			}
			if (dsk_coll != null) {
				Iterator<DataSourceKeyset> I_dsk = null;
				
				output.print("{ identifier: \"object\",  label: \"title\",  items:[" ); //$NON-NLS-1$
				I_dsk = dsk_coll.iterator();
				while (I_dsk.hasNext()){
					DataSourceKeyset dsk = I_dsk.next();
					output.print("{nodeClass:\"statdatasource\", title:\""  //$NON-NLS-1$
							+ dsk.getDataSet() 
							+ "\", datasource:\""  //$NON-NLS-1$
							+ dsk.getDataSet() 							
							+ "\", keyset:\"" //$NON-NLS-1$
						    + dsk.getKeySet()
							+ "\", epr:\'" + eprparm  //$NON-NLS-1$
							+ "\', classification:\"TomcatSet\""); //$NON-NLS-1$
					//TODO: add more properties on the datasource
					output.print(", store:["); //$NON-NLS-1$
					output.print("['epr', '"+eprparm+"']"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print(",['datasource', '"+dsk.getDataSet()+"']"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print(",['keyset', '"+dsk.getKeySet()+"']"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print("]}"); //$NON-NLS-1$
					

					if(I_dsk.hasNext()) output.print(","); //$NON-NLS-1$
				}
				output.print("]}"); //$NON-NLS-1$
			}	
		}
	}
}
