/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

/**
 * Represents an item reference
 * 
 * 
 * @author Ali Mehregani
 */
public interface IItemReference {
	/**
	 * Return a reference to the item template for this end of the relationship
	 * 
	 * @return
	 */
	public IItemTemplate getRef();

	/**
	 * Set the item template for this end of the relationship
	 * 
	 * @param ref
	 */
	public void setRef(IItemTemplate ref);

	/**
	 * Returns the id of this item reference
	 * 
	 * @return The id of the reference
	 */
	public String getId();

	/**
	 * Sets the id of this item reference
	 * 
	 * @param id The ID of this item reference
	 */
	public void setId(String id);
}
