/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.DMToolkitCommonPlugin;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IProjectConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

/**
 * Common utilities used by the data manager toolkit implementations.
 * 
 * 
 * @author David Whiteman
 */
public class Utilities {

	public static final String SRC_FOLDER = "src";

	protected static String getGeneratedConstructorComment() {
		return "// TODO Auto-generated constructor method stub";
	}

	/**
	 * Create the data manager class for the new project
	 * 
	 * @param project
	 * @param monitor
	 * @param classSource TODO
	 * @param className TODO
	 * @param packageName TODO
	 */
	public static void createProjectClass(IProject project, IProjectConfig config, IProgressMonitor monitor, String classSource, String className, String packageName) {
		IFolder folder = project.getFolder(SRC_FOLDER);
		IJavaProject javaProject = JavaCore.create(project);
		IPackageFragmentRoot fragRoot = javaProject.getPackageFragmentRoot(folder);
		IPackageFragment fragment = null;
		try {
			fragment = fragRoot.createPackageFragment(packageName, true, monitor);
			fragment.createCompilationUnit(className+".java", classSource, true, monitor);
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
		if (monitor != null) {
			monitor.worked(1);
		}
	}

	public static void createServiceGroupClass(IProject project, IProjectConfig config, IProgressMonitor monitor) throws CoreException {
		createProjectClass(project, config, monitor, config.getClassSource(), config.getGeneratedClassName(), config.getPackageName());
	}

	public static Text createLabelTextPair(final Composite composite,
			String labelString, 
			String initialFieldValue,
			boolean multi) {
		final Label label = new Label(composite, SWT.LEFT);
		label.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
		label.setText(labelString);
	
		int otherStyle = multi ? SWT.MULTI | SWT.WRAP : SWT.SINGLE;
		Text textField = new Text(composite, SWT.BORDER | otherStyle);
		textField.setLayoutData(multi ? new GridData(GridData.FILL_BOTH) : Utilities.gdhfill());
		textField.setText(initialFieldValue);
		return textField;
	}

	public static GridData gdhfill() {
		return new GridData(GridData.FILL_HORIZONTAL);
	}

	public static String populateResourceTemplate(String[] substitutionMap,
			String resourceLocation) throws CoreException {
		return populateResourceTemplate(substitutionMap, resourceLocation, DMToolkitCommonPlugin.getDefault().getBundle());
	}

	public static String populateResourceTemplate(String[] substitutionMap,
			String resourceLocation, Bundle bundle) throws CoreException {
		StringWriter writer = new StringWriter();
		String nl = System.getProperty("line.separator");
		// Read in the template for the class source from a resource file
		URL initializerSource = bundle.getResource(resourceLocation);
		InputStream inputStream = null;
		try {
			inputStream = initializerSource.openStream();
			BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
			String line = null;
			while ((line = reader.readLine()) != null) {
				// Replace all variables in the template with the values for this config
				for (int i = 0; i < substitutionMap.length; i = i + 2) {
					line = line.replace(substitutionMap[i], substitutionMap[i+1]);
				}
				writer.append(line);
				writer.append(nl);
			}
			reader.close();
			inputStream.close();
		} catch (IOException e) {
			throw DMToolkitCommonPlugin.createCoreException(e);
		}
		return writer.toString();
	}


}
