/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

public class DropRoleNode
extends DDLStatementNode {
    private String roleName;

    public void init(Object roleName) throws StandardException {
        this.initAndCheck(null);
        this.roleName = (String)roleName;
    }

    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            cc.addRequiredRolePriv(this.roleName, 20);
        }
    }

    public String toString() {
        return super.toString() + "roleName: " + this.roleName + "\n";
    }

    public String statementToString() {
        return "DROP ROLE";
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropRoleConstantAction(this.roleName);
    }
}

