/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class HasCorrelatedCRsVisitor
implements Visitor {
    private boolean hasCorrelatedCRs;

    public Visitable visit(Visitable node) {
        if (node instanceof ColumnReference) {
            if (((ColumnReference)node).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (node instanceof VirtualColumnNode) {
            if (((VirtualColumnNode)node).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (node instanceof MethodCallNode && (((MethodCallNode)node).getMethodName().equals("getTriggerExecutionContext") || ((MethodCallNode)node).getMethodName().equals("TriggerOldTransitionRows") || ((MethodCallNode)node).getMethodName().equals("TriggerNewTransitionRows"))) {
            this.hasCorrelatedCRs = true;
        }
        return node;
    }

    public boolean stopTraversal() {
        return this.hasCorrelatedCRs;
    }

    public boolean skipChildren(Visitable v) {
        return false;
    }

    public boolean hasCorrelatedCRs() {
        return this.hasCorrelatedCRs;
    }

    public void setHasCorrelatedCRs(boolean value) {
        this.hasCorrelatedCRs = value;
    }
}

