/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class ScanResultSet
extends NoPutResultSetImpl {
    private final boolean tableLocked;
    private final boolean unspecifiedIsolationLevel;
    private final int suppliedLockMode;
    private boolean isolationLevelNeedsUpdate;
    int lockMode;
    int isolationLevel;
    final ExecRow candidate;
    protected final FormatableBitSet accessedCols;

    ScanResultSet(Activation activation, int resultSetNumber, GeneratedMethod resultRowAllocator, int lockMode, boolean tableLocked, int isolationLevel, int colRefItem, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableLocked = tableLocked;
        this.suppliedLockMode = lockMode;
        if (isolationLevel == 0) {
            this.unspecifiedIsolationLevel = true;
            isolationLevel = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        } else {
            this.unspecifiedIsolationLevel = false;
        }
        this.lockMode = this.getLockMode(isolationLevel);
        this.isolationLevel = this.translateLanguageIsolationLevel(isolationLevel);
        this.candidate = (ExecRow)resultRowAllocator.invoke(activation);
        this.accessedCols = colRefItem != -1 ? (FormatableBitSet)activation.getPreparedStatement().getSavedObject(colRefItem) : null;
    }

    void initIsolationLevel() {
        if (this.isolationLevelNeedsUpdate) {
            int languageLevel = this.getLanguageConnectionContext().getCurrentIsolationLevel();
            this.lockMode = this.getLockMode(languageLevel);
            this.isolationLevel = this.translateLanguageIsolationLevel(languageLevel);
            this.isolationLevelNeedsUpdate = false;
        }
    }

    private int getLockMode(int languageLevel) {
        if (this.tableLocked || languageLevel == 4) {
            return this.suppliedLockMode;
        }
        return 6;
    }

    private int translateLanguageIsolationLevel(int languageLevel) {
        switch (languageLevel) {
            case 1: {
                return 1;
            }
            case 2: {
                if (!this.canGetInstantaneousLocks()) {
                    return 2;
                }
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        SanityManager.THROWASSERT("Unknown isolation level - " + languageLevel);
        return 0;
    }

    abstract boolean canGetInstantaneousLocks();

    public int getScanIsolationLevel() {
        return this.isolationLevel;
    }

    public void close() throws StandardException {
        this.isolationLevelNeedsUpdate = this.unspecifiedIsolationLevel;
        this.candidate.resetRowArray();
        super.close();
    }
}

