/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;

public class OpenConglomerateScratchSpace
implements DynamicCompiledOpenConglomInfo {
    private DataValueDescriptor[] row_for_export_template;
    private DataValueDescriptor[] scratch_template;
    private DataValueDescriptor[] scratch_row;
    private int[] format_ids;
    private int[] collation_ids;
    private RowPosition scratch_row_position;

    public OpenConglomerateScratchSpace(int[] format_ids, int[] collation_ids) {
        this.format_ids = format_ids;
        this.collation_ids = collation_ids;
    }

    public DataValueDescriptor[] get_row_for_export(Transaction rawtran) throws StandardException {
        if (this.row_for_export_template == null) {
            this.row_for_export_template = RowUtil.newTemplate(rawtran.getDataValueFactory(), null, this.format_ids, this.collation_ids);
        }
        return RowUtil.newRowFromTemplate(this.row_for_export_template);
    }

    public DataValueDescriptor[] get_scratch_row(Transaction rawtran) throws StandardException {
        if (this.scratch_row == null) {
            this.scratch_row = this.get_row_for_export(rawtran);
        }
        return this.scratch_row;
    }

    public DataValueDescriptor[] get_template(Transaction rawtran) throws StandardException {
        if (this.scratch_template == null) {
            this.scratch_template = TemplateRow.newRow(rawtran, null, this.format_ids, this.collation_ids);
        }
        return this.scratch_template;
    }

    public RowPosition get_scratch_row_position() {
        if (this.scratch_row_position == null) {
            this.scratch_row_position = new RowPosition();
        }
        return this.scratch_row_position;
    }
}

