/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.cosmos.me.sdd.resources.tooling.btg.Messages;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.tooling.btg.BTGLogUtil;
import org.eclipse.cosmos.me.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.sdd.tooling.btg.IBTGDataCollector;
import org.eclipse.cosmos.me.sdd.tooling.btg.InvalidCLInputException;
import org.eclipse.cosmos.me.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.sdd.tooling.btg.plugin.BTGPlugin;
import org.eclipse.cosmos.me.sdd.tooling.btg.util.PropertiesReader;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTGApplication
implements IApplication {
    private static final String OUTPUT_FILEBASE_PROPERTY = "OutputFileNameBase";
    private String aggregatorChoice = null;
    private String propertiesFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "BTG.ini";
    private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.sdd.tooling.btg");
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.sdd.tooling.btg.stdout");
    private Properties btgProperties = null;
    private Properties aggregatorProperties = null;
    private int aggregatorCount = 0;
    private IBTGDataAggregator aggregator = null;

    public void stop() {
    }

    public Object start(IApplicationContext arg0) throws Exception {
        String logFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "logger.properties";
        BTGLogUtil.initialize(logFile);
        consoleLogger.info(Messages.getString("BTGApplication.5"));
        String[] params = new String[]{};
        if (arg0.getArguments().containsKey("application.args")) {
            params = (String[])arg0.getArguments().get("application.args");
        }
        Iterator<String> paramsIter = Arrays.asList(params).iterator();
        while (paramsIter.hasNext()) {
            String param = paramsIter.next();
            if (param.equalsIgnoreCase("-help") || param.equals("-?") || param.equalsIgnoreCase("-h")) {
                this.showHelp();
                return IApplication.EXIT_OK;
            }
            if (param.equalsIgnoreCase("-usage")) {
                this.showUsage();
                return IApplication.EXIT_OK;
            }
            if (param.equalsIgnoreCase("-propertiesFile")) {
                String nextParam = paramsIter.next();
                if (!nextParam.startsWith("-")) {
                    this.propertiesFile = nextParam;
                    continue;
                }
                InvalidCLInputException e = new InvalidCLInputException(Messages.getString("BTGApplication.14"));
                consoleLogger.severe("InvalidCLInputException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
                throw e;
            }
            InvalidCLInputException e = new InvalidCLInputException(String.valueOf(Messages.getString("BTGApplication.16")) + param);
            consoleLogger.severe("InvalidCLInputException");
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        Collection<IBTGDataCollector> dataCollectorInstances = BTGPlugin.getDataCollectorInstances();
        Collection<IBTGDataAggregator> dataAggregatorInstances = BTGPlugin.getDataAggregatorInstances();
        if (dataCollectorInstances == null || dataCollectorInstances.size() == 0) {
            consoleLogger.config(Messages.getString("BTGApplication.48"));
            return IApplication.EXIT_OK;
        }
        consoleLogger.config(Messages.getString("BTGApplication.46", Integer.toString(dataCollectorInstances.size())));
        if (dataAggregatorInstances == null || dataAggregatorInstances.size() == 0) {
            consoleLogger.config(Messages.getString("BTGApplication.49"));
            return IApplication.EXIT_OK;
        }
        consoleLogger.config(Messages.getString("BTGApplication.47", Integer.toString(dataAggregatorInstances.size())));
        PropertiesReader propsReader = new PropertiesReader(this.propertiesFile);
        Collection<Properties> props = propsReader.getPropertiesList();
        consoleLogger.config(Messages.getString("BTGApplication.17", this.propertiesFile));
        this.validatePluginProps(props, dataCollectorInstances, dataAggregatorInstances, propsReader);
        if (this.aggregatorCount == 0) {
            consoleLogger.config(Messages.getString("BTGApplication.50"));
            return IApplication.EXIT_OK;
        }
        if (this.aggregatorCount > 1) {
            consoleLogger.config(Messages.getString("BTGApplication.51"));
            return IApplication.EXIT_OK;
        }
        Collection<SDDFragment> sddFragments = this.findSDDFragments(props, dataCollectorInstances);
        Collection<Object> descriptorsList = this.findDescriptorsList(dataAggregatorInstances, sddFragments);
        if (descriptorsList == null || descriptorsList.isEmpty()) {
            consoleLogger.config(Messages.getString("BTGApplication.28"));
        } else if (descriptorsList.size() != 2) {
            consoleLogger.config(Messages.getString("BTGApplication.10", String.valueOf(descriptorsList.size())));
        } else {
            consoleLogger.info(Messages.getString("BTGApplication.27"));
            this.writeDescriptorsToFiles(descriptorsList, this.btgProperties.getProperty(OUTPUT_FILEBASE_PROPERTY));
        }
        consoleLogger.config(Messages.getString("BTGApplication.29"));
        return IApplication.EXIT_OK;
    }

    private void validatePluginProps(Collection<Properties> props, Collection<IBTGDataCollector> dataCollectorInstances, Collection<IBTGDataAggregator> dataAggregatorInstances, PropertiesReader propsReader) throws ParseException {
        for (Properties p : props) {
            String pluginID;
            if ("org.eclipse.cosmos.me.sdd.tooling.btg".equals(p.get("PluginID"))) {
                propsReader.checkSupportedProperties(p, this.getSupportedProperties());
                this.btgProperties = p;
                continue;
            }
            for (IBTGDataCollector dataCollectorInstance : dataCollectorInstances) {
                pluginID = BTGPlugin.getDataCollectorPluginID(dataCollectorInstance);
                if (!p.get("PluginID").equals(pluginID)) continue;
                propsReader.checkSupportedProperties(p, dataCollectorInstance.getSupportedProperties());
            }
            for (IBTGDataAggregator dataAggregatorInstance : dataAggregatorInstances) {
                pluginID = BTGPlugin.getDataAggregatorPluginID(dataAggregatorInstance);
                if (!p.get("PluginID").equals(pluginID)) continue;
                propsReader.checkSupportedProperties(p, dataAggregatorInstance.getSupportedProperties());
                ++this.aggregatorCount;
                this.aggregatorChoice = pluginID;
                this.aggregatorProperties = p;
            }
        }
    }

    private Collection<SDDFragment> findSDDFragments(Collection<Properties> props, Collection<IBTGDataCollector> dataCollectorInstances) throws Exception {
        ArrayList<SDDFragment> sddFragments = new ArrayList<SDDFragment>();
        for (Properties p : props) {
            for (IBTGDataCollector dataCollectorInstance : dataCollectorInstances) {
                Collection<SDDFragment> descriptorList;
                String pluginID = BTGPlugin.getDataCollectorPluginID(dataCollectorInstance);
                if (!p.get("PluginID").equals(pluginID) || (descriptorList = dataCollectorInstance.collectSDDData(p)) == null) continue;
                sddFragments.addAll(descriptorList);
            }
        }
        return sddFragments;
    }

    private Collection<Object> findDescriptorsList(Collection<IBTGDataAggregator> dataAggregatorInstances, Collection<SDDFragment> sddFragments) {
        Collection<Object> descriptorsList = null;
        for (IBTGDataAggregator dataAggregatorInstance : dataAggregatorInstances) {
            String pluginID = BTGPlugin.getDataAggregatorPluginID(dataAggregatorInstance);
            if (!this.aggregatorChoice.equals(pluginID)) continue;
            consoleLogger.config(String.valueOf(Messages.getString("BTGApplication.24")) + pluginID);
            this.aggregator = dataAggregatorInstance;
        }
        if (this.aggregator != null) {
            descriptorsList = this.aggregator.aggregateSDDData(sddFragments, this.aggregatorProperties, false);
        } else {
            consoleLogger.config(Messages.getString("BTGApplication.25"));
        }
        return descriptorsList;
    }

    public Collection<BTGProperty> getSupportedProperties() {
        ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
        properties.add(new BTGProperty(OUTPUT_FILEBASE_PROPERTY, true));
        return properties;
    }

    public void writeDescriptorsToFiles(Collection<Object> descriptors, String fileNameBase) throws IOException {
        for (Object o : descriptors) {
            if (o instanceof DeploymentDescriptorType) {
                BTGApplication.marshal(o, String.valueOf(fileNameBase) + ".dd.xml");
                continue;
            }
            if (o instanceof PackageDescriptorType) {
                BTGApplication.marshal(o, String.valueOf(fileNameBase) + ".pd.xml");
                continue;
            }
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.11"));
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.13"));
        }
    }

    protected static void marshal(Object o, String fileName) {
        try {
            JAXBContext uninstallJc = JAXBContext.newInstance((String)"com.sas.schema.ittasks");
            Marshaller m = uninstallJc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            m.marshal(o, (OutputStream)new FileOutputStream(fileName));
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void showHelp() {
        consoleLogger.info(Messages.getString("BTGApplication.38"));
        consoleLogger.info(Messages.getString("BTGApplication.39"));
        consoleLogger.info(Messages.getString("BTGApplication.40"));
    }

    private void showUsage() {
        consoleLogger.info(Messages.getString("BTGApplication.41"));
        consoleLogger.info(Messages.getString("BTGApplication.42"));
    }
}

