/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.OperationCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCaseCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParameterCompare {
    protected static Vector<StringParameterType> merge(List<StringParameterType> params, List<StringParameterType> params2) {
        Vector<StringParameterType> toRemove = new Vector<StringParameterType>();
        for (StringParameterType o1 : params) {
            for (StringParameterType o2 : params2) {
                if (toRemove.contains(o2) || !StringParameterCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = StringParameterCompare.merge(o1, o2);
            }
        }
        params2.removeAll(toRemove);
        Vector<StringParameterType> finals = new Vector<StringParameterType>();
        finals.addAll(params);
        finals.addAll(params2);
        return finals;
    }

    private static boolean equals(StringParameterType o1, StringParameterType o2) {
        if (!StringCompare.equals(o1.getDefaultValue(), o2.getDefaultValue())) {
            return false;
        }
        if (o1.isSensitive() != o2.isSensitive()) {
            return false;
        }
        if (o1.isRequired() != o2.isRequired()) {
            return false;
        }
        return !OperationCompare.equals(o1.getOperation(), o2.getOperation());
    }

    protected static StringParameterType merge(StringParameterType string1, StringParameterType string2) {
        ObjectFactory objectFactory = new ObjectFactory();
        StringParameterType merged = objectFactory.createStringParameterType();
        BigInteger minLength = string1.getMinLength();
        BigInteger maxLength = string1.getMaxLength();
        merged.getValidValue().addAll(string1.getValidValue());
        if (string2.getMaxLength() != null) {
            if (maxLength == null) {
                maxLength = string2.getMaxLength();
            } else if (string2.getMaxLength().compareTo(maxLength) < 0) {
                maxLength = string2.getMaxLength();
            }
        }
        if (string2.getMinLength() != null) {
            if (minLength == null) {
                minLength = string2.getMinLength();
            } else if (string2.getMinLength().compareTo(minLength) > 0) {
                minLength = string2.getMinLength();
            }
        }
        for (String val : string2.getValidValue()) {
            if (merged.getValidValue().contains(val)) continue;
            merged.getValidValue().add(val);
        }
        merged.setMaxLength(maxLength);
        merged.setMinLength(minLength);
        merged.setDisplayName(DisplayTextCompare.merge(string1.getDisplayName(), string2.getDisplayName()));
        merged.setDescription(DisplayTextCompare.merge(string1.getDescription(), string2.getDescription()));
        merged.setCase(StringCaseCompare.merge(string1.getCase(), string2.getCase()));
        return merged;
    }
}

