/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <recordType> element in XML form
 * 
 * 
 * @author Bill Muldoon
 */
public interface IRecordType extends IXMLWritable
{
	/**
	 * set the localName 
	 * 
	 * @param localName
	 */
	public void setLocalName(String localName);
		
	/**
	 * Retrieve the localName
	 * 
	 * @return localName
	 */
	public String getLocalName();

	
	/**
	 * set the appliesTo 
	 * 
	 * @param appliesTo
	 */
	public void setAppliesTo(String appliesTo);
		
	/**
	 * Retrieve the appliesTo
	 * 
	 * @return appliesTo
	 */
	public String getAppliesTo();

}
