/***********************************************************************
 * Copyright (c) 2009 SAS Institute, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.profile.cim;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.namespace.QName;

public class InstalledProductType  {
	protected static final QName IP = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_InstalledProduct");
	protected static final QName IP_PNAME = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_InstalledProduct.ProductName");
	protected static final QName IP_PVENDOR = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_InstalledProduct.ProductVendor");
	protected static final QName IP_PVERSION = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_InstalledProduct.ProductVersion");

	protected static final String CMD_DIR = "cmd.exe /c dir \"{0}\"";
	protected static final String CMD_LS = "ls -d {0}";
	protected static final String Windows = "Windows";
	protected static final Pattern PATTERN_DIR = Pattern.compile("([0-9,]+) bytes free");
	protected static final Pattern PATTERN_LS = Pattern.compile("/[\\w.*]+");
	protected static final String OS_NAME = "os.name";

	// vendor = {0}, product = {1}, version = {2}
	protected static final String WIN_1 = "{0}\\{1}\\{2}";// vendor\product\version
	protected static final String WIN_2 = "{1}\\{2}";     // product\version
	protected static final String WIN_3 = "{1}-{2}";		// product-version
	protected static final String WIN_4 = "{0}\\{1}{2}";	// vendor\productversion
	protected static final String WIN_5 = "{0}\\{1}-{2}";	// vendor\product-version
	protected static final String WIN_6 = "{1}{2}";	    // productversion


	protected static final String UNIX_1 = "{0}/{1}/{2}"; // vendor/product/version
	protected static final String UNIX_2 = "{1}/{2}";     // product/version
	protected static final String UNIX_3 = "{1}-{2}";		// product-version
	protected static final String UNIX_4 = "{0}/{1}{2}";	// vendor/productversion
	protected static final String UNIX_5 = "{0}/{1}-{2}";	// vendor/product-version
	protected static final String UNIX_6 = "{1}{2}";	    // productversion

	protected String [] unixRoots = new String [] {"/opt/", "/usr/local/"};
	protected String [] unixPatterns = new String [] {UNIX_1, UNIX_2, UNIX_3, UNIX_4, UNIX_5, UNIX_6};

	protected String [] winRoots = new String [] {"C:", "C:\\Program Files"};
	protected String [] winPatterns = new String [] {WIN_1, WIN_2, WIN_3, WIN_4, WIN_5, WIN_6};
	

	protected  String unixFind(String path) {
		for(int i = 0; i < unixRoots.length; i++) {
			String s = runCommand(MessageFormat.format(CMD_LS, unixRoots[i] + path));
			
			// Make sure we got something.
			if (s != null) {
				Matcher m = PATTERN_LS.matcher(s);
				if (m.find()) {
					return unixRoots[i] + path;
				}
			}
		}
		return null;
	}

	protected  String winFind(String path) {
		for(int i = 0; i < winRoots.length; i++) {
			String s = runCommand(MessageFormat.format(CMD_DIR, winRoots[i] + "\\" + path));
			
			// Make sure we got something.
			if (s != null) {
				Matcher m = PATTERN_DIR.matcher(s);
				if (m.find()) {
					return winRoots[i] + "\\" + path;
				}
			}
		}
		return null;
	}

	private String runCommand(String command) {
		StringBuffer output = new StringBuffer();
		try 
		{ 
			// Run the command.
			Runtime runtime = Runtime.getRuntime(); 
			Process process = runtime.exec(command); 	
			if (process == null) { 
				return null;
			} 
			
			// Read the output of the command.
			BufferedReader inStream = new BufferedReader(new InputStreamReader(process.getInputStream())); 
			String line = null; 
			
			while ((line = inStream.readLine()) != null) { 
				output.append(line).append("\n");
			}  
		}
		catch (Exception e) { 
			return null; 
		} 
		
		return output.toString();
	}
}
