/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;
import org.apache.derby.impl.drda.FdocaConstants;

class SQLTypes {
    private SQLTypes() {
    }

    protected static int mapDB2SqlTypeToJdbcType(int sqlType, long length, int ccsid) {
        switch (SQLTypes.getNonNullableSqlType(sqlType)) {
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 492: {
                return -5;
            }
            case 480: {
                if (length == 16L) {
                    return 3;
                }
                if (length == 8L) {
                    return 8;
                }
                if (length == 4L) {
                    return 7;
                }
                return 0;
            }
            case 484: 
            case 488: 
            case 504: {
                return 3;
            }
            case 452: {
                if (ccsid == 65535 || ccsid == 0) {
                    return -2;
                }
                return 1;
            }
            case 460: 
            case 468: {
                return 1;
            }
            case 448: 
            case 464: {
                if (ccsid == 65535 || ccsid == 0) {
                    return -3;
                }
                return 12;
            }
            case 476: {
                return 12;
            }
            case 456: 
            case 472: {
                if (ccsid == 65535 || ccsid == 0) {
                    return -4;
                }
                return -1;
            }
            case 384: {
                return 91;
            }
            case 388: {
                return 92;
            }
            case 392: {
                return 93;
            }
            case 408: 
            case 412: {
                return 2005;
            }
            case 404: 
            case 960: 
            case 964: 
            case 968: {
                return 2004;
            }
        }
        return 0;
    }

    protected static int mapJdbcTypeToDB2SqlType(int jdbctype, boolean nullable, int[] outlen) throws SQLException {
        int nullAddVal = 0;
        if (nullable) {
            nullAddVal = 1;
        }
        FdocaConstants.mapJdbcTypeToDrdaType(jdbctype, nullable, outlen);
        switch (jdbctype) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                return 500 + nullAddVal;
            }
            case 4: {
                return 496 + nullAddVal;
            }
            case -5: {
                return 492 + nullAddVal;
            }
            case 7: 
            case 8: {
                return 480 + nullAddVal;
            }
            case 2: 
            case 3: {
                return 484 + nullAddVal;
            }
            case 91: {
                return 384 + nullAddVal;
            }
            case 92: {
                return 388 + nullAddVal;
            }
            case 93: {
                return 392 + nullAddVal;
            }
            case 1: {
                return 452 + nullAddVal;
            }
            case -2: {
                return 452 + nullAddVal;
            }
            case -3: 
            case 12: {
                return 448 + nullAddVal;
            }
            case -4: {
                return 456 + nullAddVal;
            }
            case 2000: {
                return 456 + nullAddVal;
            }
            case 2004: {
                return 404 + nullAddVal;
            }
            case 2005: {
                return 408 + nullAddVal;
            }
            case -1: {
                return 456 + nullAddVal;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw new SQLException("Jdbc type" + jdbctype + "not Supported yet");
            }
        }
        throw new SQLException("unrecognized sql type: " + jdbctype);
    }

    protected static int getNonNullableSqlType(int sqlType) {
        return sqlType & 0xFFFFFFFE;
    }
}

