/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.impl.io.vfmem.DataStore;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.impl.io.vfmem.VirtualRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

public class VirtualFile
implements StorageFile {
    private final String path;
    private final DataStore dStore;

    public VirtualFile(String path, DataStore dbData) {
        this.path = path;
        this.dStore = dbData;
    }

    public String[] list() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null || !entry.isDirectory()) {
            return null;
        }
        return this.dStore.listChildren(this.path);
    }

    public boolean canWrite() {
        return this.getEntry() != null && !this.getEntry().isReadOnly();
    }

    public boolean exists() {
        return this.getEntry() != null;
    }

    public boolean isDirectory() {
        DataStoreEntry entry = this.getEntry();
        return entry != null && entry.isDirectory();
    }

    public boolean delete() {
        return this.dStore.deleteEntry(this.path);
    }

    public boolean deleteAll() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return false;
        }
        if (entry.isDirectory()) {
            return this.dStore.deleteAll(this.path);
        }
        return this.delete();
    }

    public String getPath() {
        return this.path;
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public String getName() {
        return PathUtil.getBaseName(this.path);
    }

    public URL getURL() throws MalformedURLException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean createNewFile() {
        return this.dStore.createEntry(this.path, false) != null;
    }

    public boolean renameTo(StorageFile newName) {
        return this.dStore.move(this, newName);
    }

    public boolean mkdir() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return this.dStore.createEntry(this.path, true) != null;
        }
        return false;
    }

    public boolean mkdirs() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return this.dStore.createAllParents(this.path) && this.dStore.createEntry(this.path, true) != null;
        }
        return false;
    }

    public long length() {
        DataStoreEntry entry = this.getEntry();
        if (entry != null && !entry.isDirectory()) {
            return entry.length();
        }
        return 0L;
    }

    public StorageFile getParentDir() {
        String parent = PathUtil.getParent(this.path);
        if (parent == null) {
            return null;
        }
        return new VirtualFile(parent, this.dStore);
    }

    public boolean setReadOnly() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return false;
        }
        entry.setReadOnly();
        return true;
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        DataStoreEntry entry = this.getEntry();
        if (entry == null && (entry = this.dStore.createEntry(this.path, false)) == null) {
            throw new FileNotFoundException("Unable to create file: " + this.path);
        }
        return entry.getOutputStream(append);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            throw new FileNotFoundException(this.path);
        }
        return entry.getInputStream();
    }

    public int getExclusiveFileLock() {
        return 1;
    }

    public void releaseExclusiveFileLock() {
    }

    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        if (!(mode.equals("r") || mode.equals("rw") || mode.equals("rws") || mode.equals("rwd"))) {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            if (mode.equals("r")) {
                throw new FileNotFoundException("Cannot read from non-existing file: " + this.path + " (mode=" + mode + ")");
            }
            entry = this.dStore.createEntry(this.path, false);
            if (entry == null) {
                throw new FileNotFoundException("Unable to create file: " + this.path + " (mode=" + mode + ")");
            }
        }
        return new VirtualRandomAccessFile(entry, mode.equals("r"));
    }

    public String toString() {
        return "(db=" + this.dStore.getDatabaseName() + ")" + this.path + "#exists=" + this.exists() + ", isDirectory=" + this.isDirectory() + ", length=" + this.length() + ", canWrite=" + this.canWrite();
    }

    private DataStoreEntry getEntry() {
        return this.dStore.getEntry(this.path);
    }
}

