/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class BasicSortObserver
implements SortObserver {
    protected boolean doClone;
    protected boolean distinct;
    private boolean reuseWrappers;
    private ExecRow execRow;
    private Vector vector;

    public BasicSortObserver(boolean doClone, boolean distinct, ExecRow execRow, boolean reuseWrappers) {
        this.doClone = doClone;
        this.distinct = distinct;
        this.execRow = execRow;
        this.reuseWrappers = reuseWrappers;
        this.vector = new Vector();
    }

    public DataValueDescriptor[] insertNonDuplicateKey(DataValueDescriptor[] insertRow) throws StandardException {
        return this.doClone ? this.getClone(insertRow) : insertRow;
    }

    public DataValueDescriptor[] insertDuplicateKey(DataValueDescriptor[] insertRow, DataValueDescriptor[] existingRow) throws StandardException {
        return this.distinct ? (DataValueDescriptor[])null : (this.doClone ? this.getClone(insertRow) : insertRow);
    }

    public void addToFreeList(DataValueDescriptor[] objectArray, int maxFreeListSize) {
        if (this.reuseWrappers && this.vector.size() < maxFreeListSize) {
            this.vector.addElement(objectArray);
        }
    }

    public DataValueDescriptor[] getArrayClone() throws StandardException {
        int lastElement = this.vector.size();
        if (lastElement > 0) {
            DataValueDescriptor[] retval = (DataValueDescriptor[])this.vector.elementAt(lastElement - 1);
            this.vector.removeElementAt(lastElement - 1);
            return retval;
        }
        return this.execRow.getRowArrayClone();
    }

    private DataValueDescriptor[] getClone(DataValueDescriptor[] origArray) {
        DataValueDescriptor[] newArray = new DataValueDescriptor[origArray.length];
        for (int i = 0; i < origArray.length; ++i) {
            newArray[i] = origArray[i].getClone();
        }
        return newArray;
    }
}

