/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.samples.cmdbf.services.query;

import java.util.ArrayList;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl.AbstractQueryHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository;

public class RelationshipTemplateHandler
extends AbstractQueryHandler
implements IRelationshipTemplateHandler {
    public IEdges execute(IQueryResult context, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws CMDBfServiceException {
        IEdges results = QueryOutputArtifactFactory.getInstance().createEdges(relationshipTemplate);
        IRecord[] sourceRecords = source.getRecords();
        IRecord[] targetRecords = target.getRecords();
        if (sourceRecords.length != 1 || targetRecords.length != 1) {
            return results;
        }
        if (sourceRecords[0].getValue() instanceof XMLRepository.Teacher && targetRecords[0].getValue() instanceof XMLRepository.Student) {
            XMLRepository repo = (XMLRepository)this.getValue("org.eclipse.cosmos.samples.cmdbf.services.query.ICMDBfSampleConstants");
            String teacherId = ((XMLRepository.Teacher)sourceRecords[0].getValue()).identity.id;
            String studentId = ((XMLRepository.Student)targetRecords[0].getValue()).identity.id;
            XMLRepository.ClassSession[] classSessions = this.findClass(repo, teacherId, studentId);
            int i = 0;
            while (i < classSessions.length) {
                IRelationship relationship = classSessions[i].toRelationship((IGraphElementCollection)results);
                String localId = String.valueOf(teacherId) + "/" + studentId + "/" + classSessions[i].courseCode;
                relationship.addInstanceId(QueryOutputArtifactFactory.getInstance().createInstanceId("org.eclipse.cosmos.samples.cmdbf.XMLRepository", localId));
                relationship.setSourceId(QueryOutputArtifactFactory.getInstance().createInstanceId("org.eclipse.cosmos.samples.cmdbf.XMLRepository", teacherId));
                relationship.setTargetId(QueryOutputArtifactFactory.getInstance().createInstanceId("org.eclipse.cosmos.samples.cmdbf.XMLRepository", studentId));
                results.addRelationship(relationship);
                ++i;
            }
        }
        return results;
    }

    private XMLRepository.ClassSession[] findClass(XMLRepository repo, String teacherId, String studentId) {
        ArrayList<XMLRepository.ClassSession> discoveredClasses = new ArrayList<XMLRepository.ClassSession>();
        XMLRepository.ClassSession[] classes = repo.classes;
        int i = 0;
        while (i < classes.length) {
            if (teacherId.equals(classes[i].teacher.identity.id)) {
                XMLRepository.Student[] students = classes[i].students;
                int j = 0;
                while (j < students.length) {
                    if (studentId.equals(students[j].identity.id)) {
                        discoveredClasses.add(classes[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return discoveredClasses.toArray(new XMLRepository.ClassSession[discoveredClasses.size()]);
    }
}

