/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.cmdbf.services.transform.artifacts;

import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecordSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Record
implements IRecord,
IXMLWritable {
    private IXMLWritable value;
    private IRecordMetadata recordMetadata;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private IGraphElement parent;

    public Record(IGraphElement parent) {
        this.parent = parent;
    }

    @Override
    public IXMLWritable getValue() {
        return this.value;
    }

    @Override
    public void setValue(IXMLWritable value) {
        this.value = value;
    }

    @Override
    public void addNamespace(String key, String value) {
        this.getNamespaces().put(key, value);
    }

    @Override
    public IRecordMetadata getRecordMetadata() {
        return this.recordMetadata;
    }

    @Override
    public void setRecordMetadata(IRecordMetadata recordMetadata) {
        this.recordMetadata = recordMetadata;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write("<cmdbf:record");
        int count = 0;
        for (String key : this.getNamespaces().keySet()) {
            if (count == 0) {
                writer.write(" ");
            } else {
                CMDBfServicesUtil.addIndent(writer, indent + 1);
            }
            String attributeName = key.length() <= 0 ? "xmlns" : "xmlns:" + key;
            CMDBfServicesUtil.writeAttribute(writer, attributeName, this.getNamespaces().get(key));
            if (++count >= this.getNamespaces().size()) continue;
            writer.write(" ");
        }
        writer.write(">" + ICMDBfServicesConstants.nl);
        this.getValue().toXML(writer, indent + 1);
        this.getRecordMetadata().toXML(writer, indent + 1);
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("cmdbf:record")) + ICMDBfServicesConstants.nl);
    }

    @Override
    public void setValueFromString(String stringRepresentationOfValue) {
        IRecordSerializer serializer = CMDBfServicesUtil.getRecordSerializer();
        IXMLWritable writable = null;
        writable = serializer != null ? serializer.deserialize(stringRepresentationOfValue) : new CMDBfInternalUtility.XMLWritableString(stringRepresentationOfValue);
        this.setValue(writable);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespaces == null ? 0 : this.namespaces.hashCode());
        result = 31 * result + (this.getRecordMetadata().getRecordId() == null ? 0 : this.getRecordMetadata().getRecordId().hashCode());
        result = 31 * result + (this.recordMetadata == null ? 0 : this.recordMetadata.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (this.namespaces == null ? other.namespaces != null : !this.namespaces.equals(other.namespaces)) {
            return false;
        }
        if (this.parent == null && other.parent != null) {
            return false;
        }
        URI recordId = this.getRecordMetadata().getRecordId();
        URI otherRecordId = other.getRecordMetadata().getRecordId();
        if (recordId == null ? otherRecordId != null : !recordId.equals(otherRecordId)) {
            return false;
        }
        if (this.recordMetadata == null ? other.recordMetadata != null : !this.recordMetadata.equals(other.recordMetadata)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

