/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Services;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CmdRegisterServiceGroup
extends CommandEntry {
    private String _host = null;
    private String _name = null;
    private String _id = null;
    private String _soapNamespace = null;
    private String _recordTypeNamespace = null;
    private String _securityNamespace = null;
    Services _srv = null;
    List<Service> _list = null;

    CmdRegisterServiceGroup(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("RegisterServiceGroup");
        this._usage_entry = new String("USAGE_REGSRVGROUP_INFO");
    }

    public boolean validateArguments(Tokenizer st, String line) throws Exception {
        boolean found = false;
        String wsdl = null;
        Service ts = null;
        Element theWsdl = null;
        String token = null;
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_ARG2_ERR"));
            return false;
        }
        this._host = st.nextToken();
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_WSDL_ARG_ERR"));
            return false;
        }
        this._name = st.nextToken();
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_ARG2_ERR"));
            return false;
        }
        token = st.nextToken();
        if (token != null && !token.equalsIgnoreCase("null")) {
            this._id = token;
        }
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_ARG2_ERR"));
            return false;
        }
        token = st.nextToken();
        if (token != null && !token.equalsIgnoreCase("null")) {
            this._soapNamespace = token;
        }
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_ARG2_ERR"));
            return false;
        }
        token = st.nextToken();
        if (token != null && !token.equalsIgnoreCase("null")) {
            this._recordTypeNamespace = token;
        }
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_ARG2_ERR"));
            return false;
        }
        token = st.nextToken();
        if (token != null && !token.equalsIgnoreCase("null")) {
            this._securityNamespace = token;
        }
        this._srv = new Services();
        this._list = this._srv.getServices();
        while (st.hasMoreTokens()) {
            found = true;
            wsdl = st.nextToken();
            theWsdl = this.getWSDL(wsdl);
            if (theWsdl == null) {
                return false;
            }
            ts = this.makeNewService(theWsdl);
            this._list.add(ts);
        }
        if (!found) {
            this._cli.logMessage(Messages.getString("NO_SERVICE_INF_ERR"));
            return false;
        }
        return true;
    }

    public void performAction() throws Exception {
        Group theGroup = null;
        theGroup = new Group();
        theGroup.setName(this._name);
        theGroup.setHost(this._host);
        if (this._id != null) {
            theGroup.setId(this._id);
        }
        if (this._soapNamespace != null) {
            theGroup.setSoapNamespace(this._soapNamespace);
        }
        if (this._recordTypeNamespace != null) {
            theGroup.setRecordTypeNamespace(this._recordTypeNamespace);
        }
        if (this._securityNamespace != null) {
            theGroup.setSecurityNamespace(this._securityNamespace);
        }
        theGroup.setServices(this._srv);
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        if (brokerclient.registerGroup(theGroup)) {
            this._cli.logMessage(Messages.getString("OK_INFO"));
        } else {
            this._cli.logMessage(MessageFormat.format(Messages.getString("DUPLICATE_REGISTRATION_ERR"), this._name));
        }
    }

    private Service makeNewService(Element wsdl) {
        String namespace = null;
        String endpointReference = null;
        String name = null;
        String description = null;
        Service ret = new Service();
        NodeList serv = wsdl.getElementsByTagName("wsdl:service");
        NodeList desc = wsdl.getElementsByTagName("wsdl:documentation");
        namespace = wsdl.getAttribute("targetNamespace");
        ret.setNamespace(namespace);
        if (serv.getLength() > 0) {
            Element se = (Element)serv.item(0);
            name = se.getAttribute("name");
            ret.setName(name);
            NodeList p = se.getElementsByTagName("wsdl:port");
            if (p.getLength() > 0) {
                Element pe = (Element)p.item(0);
                Node pec = pe.getFirstChild();
                Element pecn = (Element)pec.getNextSibling();
                endpointReference = pecn.getAttribute("location");
                ret.setEndpointReference(endpointReference);
            }
        }
        if (desc.getLength() > 0) {
            Element doce = (Element)desc.item(0);
            description = this.extractText(doce);
            ret.setDescription(description);
        }
        return ret;
    }

    private Element getWSDL(String wsdlurl) throws Exception {
        try {
            URL url = new URL(wsdlurl);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            httpConn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpConn.setRequestMethod("GET");
            InputStream input = httpConn.getInputStream();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            Element elem = doc.getDocumentElement();
            return elem;
        }
        catch (Exception e) {
            this._cli.logMessage(Messages.getString("OPEN_WSDL_ERR"));
            return null;
        }
    }

    private String extractText(Element e) {
        NodeList children = e.getChildNodes();
        int length = children.getLength();
        for (int n = 0; n < length; ++n) {
            Node next = children.item(n);
            if (next.getNodeType() != 3) continue;
            return next.getNodeValue().trim();
        }
        return null;
    }
}

