/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.apache.xerces.xs.XSElementDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.IdentityConstraintStructure;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractTrackerDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IdentityConstraintUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintDataBuilder
extends AbstractTrackerDataBuilder<IdentityConstraintStructure> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder";
    public static final String[] IDENTITY_CONSTRAINTS = new String[]{"key", "keyref", "unique"};
    private IdentityConstraintStructure identityStruct = new IdentityConstraintStructure();
    private NamespaceContext namespaceContext;

    public IdentityConstraintDataBuilder() {
        this.addEvent(1);
    }

    @Override
    public void initialize(Map<String, Object> init) {
        super.initialize(init);
        this.namespaceContext = (NamespaceContext)init.get("namespace.context");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        IdentityConstraintStructure.IdentityConstraint[] constraints = this.retrieveConstraints();
        String[] aliases = this.getAliases();
        int i = 0;
        while (i < constraints.length) {
            IdentityConstraintStructure.IdentityInstance identityInstance = new IdentityConstraintStructure.IdentityInstance();
            identityInstance.setConstraint(constraints[i]);
            identityInstance.setNodePath(this.getNodePath());
            identityInstance.setLineNumber(this.getBaseLineNumber() + this.getLocator().getLineNumber() - 1);
            if (aliases == null || aliases.length <= 0) {
                this.identityStruct.addOrphanedConstrainedInstance(this.getOrphanInx(), identityInstance);
            } else {
                this.identityStruct.addConstrainedInstance(aliases[0], identityInstance);
            }
            ++i;
        }
    }

    private IdentityConstraintStructure.IdentityConstraint[] retrieveConstraints() {
        PSVIProvider psviProvider = this.getPsvi();
        ElementPSVI elementPSVI = psviProvider.getElementPSVI();
        XSElementDeclaration elementDeclaration = elementPSVI == null ? null : elementPSVI.getElementDeclaration();
        List<IdentityConstraintStructure.IdentityConstraint> identityConstraints = IdentityConstraintUtil.retrieveConstraints(elementDeclaration, this.namespaceContext);
        return identityConstraints.toArray(new IdentityConstraintStructure.IdentityConstraint[identityConstraints.size()]);
    }

    @Override
    public IdentityConstraintStructure getDataStructure() {
        return this.identityStruct;
    }
}

