/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.AbstractValidator;
import org.eclipse.cosmos.rm.internal.validation.core.ISMLValidator;
import org.eclipse.cosmos.rm.internal.validation.core.ValidationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSMLValidator
extends AbstractValidator
implements ISMLValidator {
    private String[] scope;
    private Map<String, Object> constraintMap;

    @Override
    public String[] getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String[] scope) {
        this.scope = scope;
    }

    protected boolean shouldAbortOnError() {
        ValidationEvent validationEvent = new ValidationEvent();
        this.fireValidationEventOccurred(validationEvent);
        return validationEvent.abortOnError();
    }

    protected boolean checkForInvalidDerivations() {
        XSModel xsModel = (XSModel)this.getAttributes().get("xs.model");
        if (xsModel == null) {
            return true;
        }
        boolean status = true;
        XSNamedMap typeDefinitions = xsModel.getComponents((short)3);
        this.constraintMap = new HashMap<String, Object>();
        int i = 0;
        int typeDefCount = typeDefinitions.getLength();
        while (i < typeDefCount) {
            XSComplexTypeDefinition complexTypeDefX;
            XSParticle particle;
            XSTypeDefinition typeDefX = (XSTypeDefinition)typeDefinitions.item(i);
            if (typeDefX.getTypeCategory() == 15 && (particle = (complexTypeDefX = (XSComplexTypeDefinition)typeDefX).getParticle()) != null) {
                boolean bl = status = status && this.isParticleValid(particle, complexTypeDefX);
                if (this.shouldAbortOnError() && !status) {
                    this.constraintMap = null;
                    return false;
                }
            }
            ++i;
        }
        this.constraintMap = null;
        return status;
    }

    protected boolean isParticleValid(XSParticle particle, XSComplexTypeDefinition typeDefinition) {
        XSTerm term = particle.getTerm();
        if (term instanceof XSElementDeclaration) {
            XSElementDeclaration elementDeclarationToCheck = (XSElementDeclaration)term;
            String qualifiedName = SMLValidatorUtil.createQualifiedName(elementDeclarationToCheck);
            Object constraint = this.constraintMap.get(qualifiedName);
            return constraint == null ? this.handleNewElement(elementDeclarationToCheck, typeDefinition) : this.handleDiscoveredElement(elementDeclarationToCheck, typeDefinition, constraint);
        }
        if (term instanceof XSModelGroup) {
            boolean valid = true;
            XSObjectList particles = ((XSModelGroup)term).getParticles();
            int j = 0;
            int particleCount = particles.getLength();
            while (j < particleCount) {
                XSParticle iParticle = (XSParticle)particles.item(j);
                boolean bl = valid = valid && this.isParticleValid(iParticle, typeDefinition);
                if (!valid && this.shouldAbortOnError()) {
                    return false;
                }
                ++j;
            }
            return valid;
        }
        return true;
    }

    protected boolean handleNewElement(XSElementDeclaration elementDeclaration, XSComplexTypeDefinition typeDefinition) {
        return true;
    }

    protected boolean handleDiscoveredElement(XSElementDeclaration elementDeclaration, XSComplexTypeDefinition typeDefinition, Object discoveredConstraint) {
        return true;
    }

    protected Map<String, Object> getConstraintMap() {
        return this.constraintMap;
    }
}

