/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.smlif.editor;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * An extended toolkit used by the SML-IF editor
 * 
 * @author Ali Mehregani
 */
public class SMLFormToolkit extends FormToolkit
{
	public SMLFormToolkit(Display display)
	{
		super(display);
	}

	
	/**
	 * Creates and returns a styled text that can be used by 
	 * a form page
	 * 
	 * @param parent The paren composite
	 * @param text The text of the control
	 * @param style The style of the control
	 * @return A styled text
	 */
	public StyledText createStyledtext(Composite parent, String text, int style) 
	{
		StyledText styledText = new StyledText(parent, style | SWT.FLAT | super.getOrientation());
		if (text != null)
			styledText.setText(text);
		adapt(styledText, true, false);
		return styledText;
	}
	
	
	/**
	 * Creates and returns a sash form
	 * 
	 * @param parent The parent
	 * @param style The associated style
	 * @return A sash form
	 */
	public SashForm createSashForm (Composite parent, int style)
	{
		SashForm sashForm = new SashForm(parent, style | getOrientation());
		adapt(sashForm);
		return sashForm;
	}
	
}
