/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a collection of graph elements, such as items or 
 * relationships
 * 
 * 
 * @author David Whiteman
 * @author Ali Mehregani
 */
public interface IGraphElementCollection extends IXMLWritable 
{

	/**
	 * Indicates whether this collection is empty or not
	 * 
	 * @return true iff this collection is empty; false otherwise
	 */
	public boolean isEmpty();

	
	/**
	 * Returns the size of this graph element collection
	 * 
	 * @return The size of this graph element collection
	 */
	public int getSize();

	
	/**
	 * Answer an array of all IGraphElements in this collection
	 * 
	 * @return
	 */
	public IGraphElement[] getElements();

	
	/**
	 * Set the contents of this collection to be equal to <tt>elements</tt>
	 * 
	 * @param elements
	 */
	public void setElements(IGraphElement[] elements);
	
	
	/**
	 * Adds an element to this graph element collection
	 * 
	 * @param element The element to be added
	 */
	public void addElement (IGraphElement element);
	
	
	/**
	 * Removes 'element' from this graph element collection.
	 * This method has no effect if element is not part of this 
	 * collection
	 * 
	 * @param element The element to be removed
	 */
	public void removeElement (IGraphElement element);
}
