/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.registration.transform.input.artifacts;

import java.util.List;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.IRegistrationTransformerConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRelationshipList;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;

public class RelationshipList extends GraphElementCollection implements IRelationshipList {
	public RelationshipList(boolean itemListId, List<IGraphElement> elements) {
		super(itemListId, elements);
	}

	public RelationshipList(boolean itemListId) {
		super(itemListId);
	}

	public void addRelationship(IRelationship relationship) 
	{
		getCollection().add(relationship);
	}

	protected String getElementName(boolean idList) {
		return 	idList ? 
				IRegistrationTransformerConstants.RELATIONSHIP_ID_LIST_ELEMENT : 
				IRegistrationTransformerConstants.RELATIONSHIP_LIST_ELEMENT;
	}
}
