/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import org.eclipse.cosmos.rm.internal.validation.reference.ReferenceContext;
import java.net.URI;

/**
 * This class is used to collect each reference scheme instance within the context of a single SML reference.
 *
 * @author John Arwe
 */
public class ReferenceDescriptor
{
	private int lineNumber;
	private String filePath;
	private String reference;					//	String containing the reference string, e.g. text content of an sml:uri element
	private ReferenceContext context;		//	SML reference within which this reference scheme instance is housed
	private URI baseURIValue;			//	May be specific to scheme markup, e.g. xml:base on sml:uri element

	
	public ReferenceDescriptor(String filePath, int lineNumber, String reference, URI baseURI)
	{
		this.filePath = filePath;
		this.lineNumber = lineNumber;
		this.reference = reference;
		this.baseURIValue = baseURI;	//	Might be null or a relative reference
	}
	
	/**
	 * @return the lineNumber
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}
	/**
	 * @return the filePath
	 */
	public String getFilePath()
	{
		return filePath;
	}
	/**
	 * @return the reference
	 */
	public String getReference()
	{
		return reference;
	}
	/**
	 * @return the reference
	 */
	public URI getBaseURI()
	{
		return baseURIValue;
	}


	public void setContext(ReferenceContext refContext) {
		
		context = refContext;
	}

	/**
	 * @return the context
	 */
	public ReferenceContext getContext() {
		return context;
	}
}
