/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;


/**
 * A type node is simply the declaration of a type under a specific context 
 * 
 * @author Ali Mehregani
 */
public class TypeNode
{
	private String type;
	private String uri;
	
	public TypeNode()
	{
		this(IValidationConstants.EMPTY_STRING, IValidationConstants.EMPTY_STRING);
	}
	
	public TypeNode(String type, String uri)
	{
		this.type = type;
		this.uri = uri;
		
		type = type == null ? IValidationConstants.EMPTY_STRING : type;
		uri = uri == null ? IValidationConstants.EMPTY_STRING : uri;
	}
	
	/**
	 * Returns the type of the element
	 * 
	 * @return the type of the element
	 */
	public String getType()
	{
		return type;
	}

	/**
	 * Sets the type of the element
	 * 
	 * @param type
	 *            type of the element
	 */
	public void setType(String type)
	{
		this.type = type;
	}

	/**
	 * @return the uri
	 */
	public String getUri()
	{
		return uri;
	}

	/**
	 * @param uri the uri to set
	 */
	public void setUri(String uri)
	{
		this.uri = uri;
	}
	
	
	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj)
	{
		if (obj instanceof TypeNode)
		{
			TypeNode typeNode = (TypeNode)obj;
			return uri == null ? typeNode.getUri() == null : uri.equals(typeNode.getUri()) &&
				   type == null ? typeNode.getType() == null : type.equals(typeNode.getType());
		}
		return false;
	}
	
	@Override
	public String toString() {
		return getClass().getSimpleName() + ":" + getUri() + ":" + getType();
	}
}
