/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.response.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryServiceElementCollection;

/**
 * Object representing a query result from the repository
 * 
 * @author David Whiteman
 * @author Ali Mehregani
 */
public class QueryResult implements IQueryResult
{
	private Map<String, INodes> nodes;
	private Map<String, IEdges> edges;

	public QueryResult()
	{
		nodes = new Hashtable<String, INodes>();
		edges = new Hashtable<String, IEdges>();
	}
	
	public INodes[] getAllNodes() 
	{		
		return nodes.values().toArray(new INodes[nodes.size()]);
	}

	
	public INodes getNodes (String id)
	{
		return nodes.get(id);
	}
	
	public IEdges[] getAllEdges() 
	{
		return edges.values().toArray(new IEdges[edges.size()]);
	}
	
	public IEdges getEdges(String id) 
	{
		return edges.get(id);
	}
	
	public void addNodes (INodes nodes)
	{
		this.nodes.put(nodes.getId(), nodes);
	}
	
	public void removeNodes (INodes nodes)
	{
		this.nodes.remove(nodes.getId());
	}
	
	public void addEdges (IEdges edges)
	{
		this.edges.put(edges.getId(), edges);
	}
	
	public void removeEdges (IEdges edges)
	{
		this.edges.remove(edges.getId());
	}

	public String[] getNodesIds()
	{
		return nodes.keySet().toArray(new String[nodes.size()]);
	}
	
	public String[] getEdgesIds()
	{
		return edges.keySet().toArray(new String[edges.size()]);
	}
	
	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET +
					 ICMDBfServicesConstants.CMDBF_PREFIX + 
					 IQueryTransformerConstants.QUERY_RESULT_ELEMENT + 
					 " xmlns:" + ICMDBfServicesConstants.CMDBF_PREFIX_RAW + "=\""+ICMDBfServicesConstants.CMDBF_MODEL_NAMESPACE+ICMDBfServicesConstants.DOUBLE_QUOTE+
					 ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, new ArrayList<IQueryServiceElementCollection>(nodes.values()));
		CMDBfServicesUtil.outputListToXML(writer, indent+1, new ArrayList<IQueryServiceElementCollection>(edges.values()));
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.QUERY_RESULT_ELEMENT)+ICMDBfServicesConstants.nl);
		
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((edges == null) ? 0 : edges.hashCode());
		result = prime * result + ((nodes == null) ? 0 : nodes.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final QueryResult other = (QueryResult) obj;
		if (nodes == null) {
			if (other.nodes != null)
				return false;
		} else if (!nodes.equals(other.nodes))
			return false;
		if (edges == null) {
			if (other.edges != null)
				return false;
		} else if (!edges.equals(other.edges))
			return false;
		return true;
	}
}
