/***********************************************************************
 * Copyright (c) 2009 SAS Institute, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.profile.cim.handler;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.profile.cim.J2eeServerType;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class JBossServerHandler extends J2eeServerType implements IResourceHandler {
	
	static final String JBOSS = "JBoss";
	static final String JBOSSAS = "JBossAS";

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			CapacityConstraintType constraint) {
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			ConsumptionConstraintType constraint) {
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			PropertyConstraintType constraint) {
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			ConditionalPropertyConstraintType constraint) {
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			VersionConstraintType constraint) {
		return false;
	}
	
	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			RequirementResourceConstraintType constraint) {
		
		String name = null;
		String version = null;
		String vendor = null;
		String status = null;
		
		for (Object o : constraint.getResourceConstraintGroup()) {
			if (o instanceof JAXBElement<?>) {
				Object value = ((JAXBElement<?>)o).getValue();
		
				String constraintValue = null;
				QName constraintName = null;
				
				if (value instanceof PropertyConstraintType) {
					if (value instanceof ConditionalPropertyConstraintType) {
						ConditionalPropertyConstraintType cc = (ConditionalPropertyConstraintType) value;
						constraintName = cc.getPropertyName();
						constraintValue = cc.getValue();
					} else if (value instanceof PropertyConstraintType) {
						PropertyConstraintType cc = (PropertyConstraintType) value;
						constraintName = cc.getPropertyName();
						constraintValue = cc.getValue();
					}
				}
				else if (value instanceof VersionConstraintType) {
					// not handling versions for installed product yet.
				}
				
				if (J2EE_NAME.equals(constraintName))
					name = constraintValue;
				else if (J2EE_VERSION.equals(constraintName))
					version = constraintValue;
				else if (J2EE_VENDOR.equals(constraintName))
					vendor = constraintValue;
				else if (J2EE_STATUS.equals(constraintName))
					status = constraintValue;
			}	
		}
		
		if(JBOSS.equalsIgnoreCase(name)) {
			if (System.getProperty(OS_NAME).contains(Windows)) {
				for(int i=0; i<winPatterns.length; i++) {
					String s = winFind(MessageFormat.format(winPatterns[i], name, vendor, version));
					if(s != null && getStatus().equals(status)) {
						return true;
					}
				}
			}
			else {
				for(int i=0; i<unixPatterns.length; i++) {
					String s = unixFind(MessageFormat.format(unixPatterns[i], name, vendor, version));
					if(s != null && getStatus().equals(status)) {
						return true;
					}
				}
			}
		}
		
		return false;
	}
	
	public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname) {
		return null;
	}

	public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
		return null;
	}

	private String getStatus() {
		// todo -- need to look at jmxconsole as yet another way...http://hostname:8080/jmx-console
		URL url = null;
		try {
			url = new URL(LOCALHOST);

			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("PUT");
			connection.connect();
			connection.getOutputStream();
			int code = connection.getResponseCode();
			
			// http://www.w3.org/Protocols/HTTP/HTRESP.html
			if (code >= 200 && code < 400) { 
				return OK;
			}
			else if (code >= 400) { 
				return ERROR;
			}
		}
		catch (IOException e) {
			return UNKNOWN;
		}
		
		return UNKNOWN;
	}
}
